/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.CodeUnit;
import com.pnf.libravm.FunctionHandle;
import com.pnf.libravm.Libra;
import com.pnf.libravm.LibraPoolEntry;
import com.pnf.libravm.LibraUnit;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class FunctionDef
extends LibraPoolEntry {
    @SerId(value=1)
    private int function_handle_index;
    @SerId(value=2)
    private int flags;
    @SerId(value=3)
    private CodeUnit code;

    public FunctionDef(int function_handle_index, int flags, CodeUnit code) {
        this.function_handle_index = function_handle_index;
        this.flags = flags;
        this.code = code;
    }

    public FunctionHandle getHandle(LibraUnit l) {
        return (FunctionHandle)l.functionHandles.get(this.function_handle_index);
    }

    public String getName(LibraUnit l) {
        return this.getHandle(l).getName(l);
    }

    public CodeUnit getCode() {
        return this.code;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        if (this.flags != 0) {
            t.append((Object)Libra.formatFunctionFlags(this.flags)).append((Object)" ");
        }
        ((FunctionHandle)l.functionHandles.get(this.function_handle_index)).format(l, t);
        t.eol();
        t.indent();
        this.code.format(l, t);
        return t.unindent();
    }
}

