/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraObject;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.LocalSignature;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.List;

@Ser
class CodeUnit
implements LibraObject {
    @SerId(value=1)
    private int max_stack_size;
    @SerId(value=2)
    private int local_sig_index;
    @SerId(value=3)
    private List<LibraInstruction> insnlist;
    @SerId(value=4)
    private int bytecode_offset;

    public CodeUnit(int max_stack_size, int local_sig_index, List<LibraInstruction> insnlist) {
        this.max_stack_size = max_stack_size;
        this.local_sig_index = local_sig_index;
        this.insnlist = insnlist;
    }

    public int getMaxStackSize() {
        return this.max_stack_size;
    }

    public LocalSignature getLocals(LibraUnit l) {
        return (LocalSignature)l.localSignatures.get(this.local_sig_index);
    }

    public List<LibraInstruction> getInstructions() {
        return this.insnlist;
    }

    public int getInsnFileSize() {
        int size = 0;
        for (LibraInstruction insn : this.insnlist) {
            size += insn.getSize();
        }
        return size;
    }

    public int getInsnFileOffset() {
        return this.bytecode_offset;
    }

    public void setInsnFileOffset(int offset) {
        this.bytecode_offset = offset;
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        t.append((Object)"max_stack_size: ").append(this.max_stack_size).eol();
        t.append((Object)"locals: ");
        ((LocalSignature)l.localSignatures.get(this.local_sig_index)).format(l, t).eol();
        int i = 0;
        for (LibraInstruction insn : this.insnlist) {
            t.append((Object)insn.format(i)).eol();
            ++i;
        }
        return t;
    }
}

