/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat.internal;

import com.pnf.plugin.oat.internal.DexFile;
import com.pnf.plugin.oat.internal.OAT;
import com.pnf.plugin.oat.internal.StreamReader;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

@Ser
public class OATFile
extends StreamReader {
    @SerId(value=1)
    private byte[] magic = new byte[4];
    @SerId(value=2)
    private int version;
    @SerId(value=3)
    private int checksum;
    @SerId(value=4)
    private int instructionSet;
    @SerId(value=5)
    private int instructionSetFeatures;
    @SerId(value=6)
    private int dexFileCount;
    @SerId(value=7)
    private int executableOffset;
    @SerId(value=8)
    private int interpreterToInterpreterBridgeOffset;
    @SerId(value=9)
    private int interpreterToCompiledCodeBridgeOffset;
    @SerId(value=10)
    private int jniDlsymLookupOffset;
    @SerId(value=11)
    private int portableImtConflictTrampolineOffset;
    @SerId(value=12)
    private int portableResolutionTrampolineOffset;
    @SerId(value=13)
    private int portableToInterpreterBridgeOffset;
    @SerId(value=14)
    private int quickGenericJniTrampolineOffset;
    @SerId(value=15)
    private int quickImtConflictTrampolineOffset;
    @SerId(value=16)
    private int quickResolutionTrampolineOffset;
    @SerId(value=17)
    private int quickToInterpreterBridgeOffset;
    @SerId(value=18)
    private int imagePatchDelta;
    @SerId(value=19)
    private int imageFileLocationOatChecksum;
    @SerId(value=20)
    private int imageFileLocationOatDataBegin;
    @SerId(value=21)
    private int keyValueStoreSize;
    @SerId(value=22)
    private byte[] keyValueStore;
    @SerId(value=23)
    private List<DexFile> dexFiles = new ArrayList<DexFile>();

    @SerConstructor
    protected OATFile() {
    }

    public OATFile(byte[] data) {
        int idex;
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        boolean offset = false;
        stream.read(this.magic, 0, 4);
        if (!OATFile.checkBytes(data, 0, OAT.magic)) {
            throw new IllegalArgumentException("Magic number does not match");
        }
        this.version = Integer.parseInt(new String(OATFile.readString(stream)).replaceFirst("^0+(?!$)", "").trim());
        this.checksum = OATFile.readInt(stream);
        if (this.version < 39) {
            throw new IllegalArgumentException("Unsupported OAT version " + this.version);
        }
        if (this.version > 88) {
            logger.warn("OAT version %d partially unsupported, unexpected behavior may happen", new Object[]{this.version});
        }
        this.instructionSet = OATFile.readInt(stream);
        this.instructionSetFeatures = OATFile.readInt(stream);
        this.dexFileCount = OATFile.readInt(stream);
        this.executableOffset = OATFile.readInt(stream);
        this.interpreterToInterpreterBridgeOffset = OATFile.readInt(stream);
        this.interpreterToCompiledCodeBridgeOffset = OATFile.readInt(stream);
        this.jniDlsymLookupOffset = OATFile.readInt(stream);
        if (this.version <= 45) {
            this.portableImtConflictTrampolineOffset = OATFile.readInt(stream);
            this.portableResolutionTrampolineOffset = OATFile.readInt(stream);
            this.portableToInterpreterBridgeOffset = OATFile.readInt(stream);
        }
        this.quickGenericJniTrampolineOffset = OATFile.readInt(stream);
        this.quickImtConflictTrampolineOffset = OATFile.readInt(stream);
        this.quickResolutionTrampolineOffset = OATFile.readInt(stream);
        this.quickToInterpreterBridgeOffset = OATFile.readInt(stream);
        this.imagePatchDelta = OATFile.readInt(stream);
        this.imageFileLocationOatChecksum = OATFile.readInt(stream);
        this.imageFileLocationOatDataBegin = OATFile.readInt(stream);
        this.keyValueStoreSize = OATFile.readInt(stream);
        this.keyValueStore = new byte[this.keyValueStoreSize];
        for (int index = 0; index < this.keyValueStoreSize; ++index) {
            stream.read(this.keyValueStore, index, 1);
        }
        byte[] headerBytes = new byte[data.length - stream.available()];
        boolean current = false;
        for (idex = 0; idex < this.dexFileCount; ++idex) {
            int dexFileLocationSize = OATFile.readInt(stream);
            if (dexFileLocationSize > 65536) {
                logger.warning("OAT File entry format appears to be unsupported", new Object[0]);
                break;
            }
            String dexFileLocation = OATFile.readString(stream, dexFileLocationSize);
            int dexFileLocationChecksum = OATFile.readInt(stream);
            int dexFilePointer = OATFile.readInt(stream);
            this.dexFiles.add(new DexFile(data, dexFilePointer, data.length - dexFilePointer, dexFileLocation));
        }
        if (this.dexFiles.size() < this.dexFileCount) {
            logger.info("Searching for %d additional DEX files heuristically...", new Object[]{this.dexFileCount - this.dexFiles.size()});
            idex = 2;
            byte[] b = new byte[4096];
            int n = stream.read(b, 0, 4096);
            for (int i = 0; i <= n - 4; ++i) {
                int val;
                int v = OATFile.littleEndianBytesToInt(b, i);
                if (v < 0 || v + 100 > data.length || (val = OATFile.littleEndianBytesToInt(data, v)) != 175662436) continue;
                String name = String.format("Unknown DEX #%d", this.dexFiles.size() + 1);
                this.dexFiles.add(new DexFile(data, v, data.length - v, name));
                if (this.dexFiles.size() >= this.dexFileCount) break;
            }
        }
    }

    public static int littleEndianBytesToInt(byte[] array, int offset) {
        return array[offset] & 0xFF | array[offset + 1] << 8 & 0xFF00 | array[offset + 2] << 16 & 0xFF0000 | array[offset + 3] << 24 & 0xFF000000;
    }

    public int getVersion() {
        return this.version;
    }

    public int getDexFileCount() {
        return this.dexFileCount;
    }

    public List<DexFile> getDexFiles() {
        return this.dexFiles;
    }

    public String getISAString() {
        switch (this.instructionSet) {
            case 1: {
                return "ARM";
            }
            case 2: {
                return "ARM64";
            }
            case 3: {
                return "ARM_Thumb2";
            }
            case 4: {
                return "X86";
            }
            case 5: {
                return "X86_64";
            }
            case 6: {
                return "MIPS";
            }
            case 7: {
                return "MIPS64";
            }
        }
        return "Unknown";
    }

    public String getKeyValueStore() {
        return new String(this.keyValueStore);
    }
}

