/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.pnf.plugin.pdf.filter.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.ImageDataDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JPXDecode {
    public static ByteBuffer decode(PDFObject dict, ByteBuffer buf, PDFObject params) throws PDFParseException {
        BufferedImage bimg = JPXDecode.loadImageData(buf);
        byte[] output = ImageDataDecoder.decodeImageData(bimg);
        return ByteBuffer.wrap(output);
    }

    private static BufferedImage loadImageData(ByteBuffer buf) throws PDFParseException {
        ImageReader reader = null;
        try {
            BufferedImage bimg;
            byte[] input = new byte[buf.remaining()];
            buf.get(input);
            Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType("image/jpeg2000");
            if (!readers.hasNext()) {
                throw new PDFParseException("JPXDecode failed. No reader available");
            }
            reader = readers.next();
            reader.setInput(new MemoryCacheImageInputStream(new ByteArrayInputStream(input)));
            BufferedImage bufferedImage = bimg = reader.read(0);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new PDFParseException("JPXDecode failed", e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

