/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfString;
import com.pnf.plugin.pdf.parser.IPdfParsable;
import com.pnf.plugin.pdf.parser.PdfAttributeValue;
import com.pnf.plugin.pdf.parser.PdfComment;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;

public class PdfObjectParser {
    private IPdfParsable attribute = null;
    private AbstractPdfParsableAttribute parent;

    public PdfObjectParser(AbstractPdfParsableAttribute parent) {
        this.parent = parent;
    }

    public int parse(byte[] data, int cursor) throws StartObjFoundException {
        if (PdfDictionary.isStartToken(data, cursor)) {
            this.attribute = new PdfDictionary(this.parent, cursor);
        } else if (PdfString.isStartToken(data, cursor)) {
            this.attribute = new PdfString(this.parent, cursor);
        } else if (PdfArray.isStartToken(data, cursor)) {
            this.attribute = new PdfArray(this.parent, cursor);
        } else {
            if (PdfSpecialCharacters.isComment(data[cursor])) {
                return PdfComment.skipCommentsIfSome(data, cursor - 1);
            }
            this.attribute = new PdfAttributeValue(this.parent, cursor);
        }
        return this.attribute.parse(data, cursor);
    }

    public IPdfAttribute getPdfAttribute() throws StartObjFoundException {
        return this.attribute != null ? this.attribute.getPdfAttribute() : null;
    }
}

