/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.AbstractPdfSimpleValue;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.Arrays;
import java.util.List;

@Ser
public class PdfName
extends AbstractPdfSimpleValue {
    private static final ILogger logger = GlobalLog.getLogger(PdfName.class);
    public static final List<String> SUSPICIOUS_JS = Arrays.asList("/JavaScript", "/JS");
    public static final List<String> SUSPICIOUS_AUTOMATIC_ACTION = Arrays.asList("/OpenAction", "/AA");
    public static final List<String> SUSPICIOUS_FLASH = Arrays.asList("/RichMedia");
    public static final List<String> SUSPICIOUS_FORM = Arrays.asList("/AcroForm");
    public static final List<String> SUSPICIOUS_XFA = Arrays.asList("/XFA");

    public PdfName(String value, AbstractPdfParsableAttribute parent, int startIndex) {
        super(PdfName.escapeValue(value), parent, startIndex);
        if (SUSPICIOUS_JS.contains(value)) {
            parent.getPdfStatictics().addUnitNotification((IPdfAttribute)this, PdfStatistics.SuspiciousType.PotentialHarmfulToken, "Javascript", null, value.equals("/JS"));
        } else if (SUSPICIOUS_AUTOMATIC_ACTION.contains(value)) {
            parent.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.PotentialHarmfulToken, "Automatic Action");
        } else if (SUSPICIOUS_FLASH.contains(value)) {
            parent.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.PotentialHarmfulToken, "Flash");
        } else if (SUSPICIOUS_FORM.contains(value)) {
            parent.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.PotentialHarmfulToken, "AcroForm");
        } else if (SUSPICIOUS_XFA.contains(value)) {
            parent.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.PotentialHarmfulToken, "XML Forms Architecture");
        }
    }

    private static String escapeValue(String value) {
        if (!value.contains("#")) {
            return value;
        }
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char valueChar = value.charAt(i);
            if (valueChar == '#') {
                String hexaRep = value.substring(i + 1, i + 3);
                Integer specialChar = null;
                try {
                    specialChar = Integer.valueOf(hexaRep, 16);
                    stb.append((char)specialChar.intValue());
                }
                catch (Exception e) {
                    logger.catching((Throwable)e);
                }
                i += 2;
                continue;
            }
            stb.append(valueChar);
        }
        return stb.toString();
    }

    public static boolean isName(String value) {
        return value.charAt(0) == '/';
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.Name;
    }
}

