/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XFAParser {
    private static final ILogger logger = GlobalLog.getLogger(XFAParser.class);
    private XFAHandler xfa = new XFAHandler();

    public void parse(byte[] xmlContent) throws ParserConfigurationException, SAXException, IOException {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer parsed = decoder.decode(ByteBuffer.wrap(xmlContent));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        try (ReaderInputStream is = new ReaderInputStream((Reader)new CharArrayReader(parsed.array()));){
            parser.parse((InputStream)is, (DefaultHandler)this.xfa);
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
            logger.error("Error while parsing XFA content", new Object[0]);
        }
    }

    public List<byte[]> getJavaScripts() {
        return this.xfa.javascripts;
    }

    public List<byte[]> getScripts() {
        return this.xfa.scripts;
    }

    private class XFAHandler
    extends DefaultHandler {
        private List<byte[]> javascripts = new ArrayList<byte[]>();
        private List<byte[]> scripts = new ArrayList<byte[]>();
        private Script script;

        private XFAHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.script != null) {
                logger.error("Previous script node was not closed before %s", new Object[]{qName});
                this.endScript();
            }
            if (qName.equals("script")) {
                this.startScript();
                String sc = attributes.getValue("contentType");
                if ("application/x-javascript".equals(sc)) {
                    this.script.isJs = true;
                }
            }
        }

        private void startScript() {
            this.script = new Script();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.script != null && !qName.equals("script")) {
                logger.error("Unexpected end tag %s, expected script end node", new Object[]{qName});
            }
            this.endScript();
        }

        private void endScript() {
            if (this.script != null) {
                if (this.script.isJs) {
                    this.javascripts.add(this.script.stb.toString().getBytes());
                } else {
                    this.scripts.add(this.script.stb.toString().getBytes());
                }
                this.script = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.script != null) {
                this.script.stb.append(ch, start, length);
            }
        }

        private class Script {
            private StringBuilder stb = new StringBuilder();
            private boolean isJs = false;

            private Script() {
            }
        }
    }
}

