/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.PdfFormatter;
import com.pnf.plugin.pdf.address.AddressImpl;
import com.pnf.plugin.pdf.address.IAddress;
import com.pnf.plugin.pdf.address.IAddressProvider;
import com.pnf.plugin.pdf.address.INodeCoordinatesProvider;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;

public class AddressUtils
implements IAddressProvider,
INodeCoordinatesProvider {
    private static final ILogger logger = GlobalLog.getLogger(AddressUtils.class);
    private static final List<IPdfAttribute> EMPTY_PATH = new ArrayList<IPdfAttribute>();
    List<PdfIndirectObj> objects;

    private static String coordinatesToAddress(List<Integer> coordinates) {
        return Strings.join((String)"/", coordinates);
    }

    private static List<Integer> addressToCoords(String address) {
        String[] coordinatesStr = address.split("/");
        ArrayList<Integer> coordinates = new ArrayList<Integer>();
        for (String coor : coordinatesStr) {
            if (coor == null || coor.length() <= 0) continue;
            coordinates.add(Integer.valueOf(coor));
        }
        return coordinates;
    }

    private static List<IPdfAttribute> attributeToPath(IPdfAttribute element) {
        if (element == null) {
            return null;
        }
        ArrayList<IPdfAttribute> path = new ArrayList<IPdfAttribute>();
        for (IPdfAttribute currentNode = element; currentNode != null; currentNode = currentNode.getParent()) {
            path.add(0, currentNode);
        }
        if (path.size() > 1) {
            path.remove(1);
        }
        return path;
    }

    protected List<Integer> pathToCoordinates(List<IPdfAttribute> path) {
        logger.trace("path to coordinates: %s", new Object[]{AddressUtils.toString(path, true)});
        ArrayList<Integer> coordinates = new ArrayList<Integer>();
        IPdfAttribute attribute = path.remove(0);
        coordinates.add(this.objects.indexOf(attribute));
        if (!path.isEmpty()) {
            coordinates.addAll(AddressUtils.pathToCoordinates(path, ((PdfIndirectObj)attribute).getAttribute()));
        }
        logger.trace("path to coordinates result: %s", new Object[]{Strings.joinList(coordinates)});
        return coordinates;
    }

    private static List<Integer> pathToCoordinates(List<IPdfAttribute> path, IPdfAttribute attribute) {
        if (path.isEmpty()) {
            return new ArrayList<Integer>();
        }
        switch (attribute.getType()) {
            case Array: {
                return AddressUtils.pathToCoordinates(path, (PdfArray)attribute);
            }
            case Dictionary: {
                return AddressUtils.pathToCoordinates(path, (PdfDictionary)attribute);
            }
            case Stream: {
                return AddressUtils.pathToCoordinates(path, ((PdfStream)attribute).getDictionary());
            }
        }
        return new ArrayList<Integer>();
    }

    private static List<Integer> pathToCoordinates(List<IPdfAttribute> path, PdfArray attribute) {
        ArrayList<Integer> coordinates = new ArrayList<Integer>();
        IPdfAttribute child = path.remove(0);
        coordinates.add(attribute.getAttributes().indexOf(child));
        coordinates.addAll(AddressUtils.pathToCoordinates(path, child));
        return coordinates;
    }

    private static List<Integer> pathToCoordinates(List<IPdfAttribute> path, PdfDictionary attribute) {
        ArrayList<Integer> coordinates = new ArrayList<Integer>();
        List<PdfDictionaryAttribute> attributes = attribute.getAttributes();
        IPdfAttribute child = path.remove(0);
        for (int i = 0; i < attributes.size(); ++i) {
            if (!attributes.get(i).equals(child) && !attributes.get(i).getKey().equals(child) && !attributes.get(i).getValue().equals(child)) continue;
            coordinates.add(i);
            coordinates.addAll(AddressUtils.pathToCoordinates(path, child));
            return coordinates;
        }
        logger.error("Can not retrieve attribute %s in dictionary %s", new Object[]{AddressUtils.toString(child, false), AddressUtils.toString(attributes, false)});
        return coordinates;
    }

    protected List<IPdfAttribute> coordinateToPath(List<Integer> coordinates) {
        ArrayList<IPdfAttribute> path = new ArrayList<IPdfAttribute>();
        List<Integer> c = AddressUtils.cloneList(coordinates);
        PdfIndirectObj o = this.objects.get(c.remove(0));
        path.add(o);
        path.addAll(AddressUtils.coordinateToPath(c, o.getAttribute()));
        return path;
    }

    private static List<IPdfAttribute> coordinateToPath(List<Integer> coordinates, IPdfAttribute attribute) {
        if (coordinates.isEmpty()) {
            return EMPTY_PATH;
        }
        switch (attribute.getType()) {
            case Dictionary: {
                return AddressUtils.coordinateToPath(coordinates, (PdfDictionary)attribute);
            }
            case Stream: {
                return AddressUtils.coordinateToPath(coordinates, ((PdfStream)attribute).getDictionary());
            }
            case Array: {
                return AddressUtils.coordinateToPath(coordinates, (PdfArray)attribute);
            }
        }
        logger.debug("The element of type %s can not have a child: %s", new Object[]{attribute.getType(), AddressUtils.toString(attribute, false)});
        return EMPTY_PATH;
    }

    private static List<IPdfAttribute> coordinateToPath(List<Integer> c, PdfArray attribute) {
        ArrayList<IPdfAttribute> path = new ArrayList<IPdfAttribute>();
        int index = c.remove(0);
        IPdfAttribute child = attribute.getAttributes().get(index);
        path.add(child);
        path.addAll(AddressUtils.coordinateToPath(c, child));
        return path;
    }

    private static List<IPdfAttribute> coordinateToPath(List<Integer> c, PdfDictionary attribute) {
        ArrayList<IPdfAttribute> path = new ArrayList<IPdfAttribute>();
        int index = c.remove(0);
        PdfDictionaryAttribute child = attribute.getAttributes().get(index);
        path.add(child);
        path.addAll(AddressUtils.coordinateToPath(c, child.getValue()));
        return path;
    }

    private static <E> List<E> cloneList(List<E> list) {
        ArrayList<E> clone = new ArrayList<E>();
        for (E elementsFromList : list) {
            clone.add(elementsFromList);
        }
        return clone;
    }

    protected static String toString(List<? extends IPdfAttribute> attributes, boolean recursive) {
        if (attributes == null) {
            return "";
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (IPdfAttribute iPdfAttribute : attributes) {
            strList.add(AddressUtils.toString(iPdfAttribute, recursive));
        }
        return Strings.joinList(strList);
    }

    private static String toString(IPdfAttribute attribute, boolean recursive) {
        switch (attribute.getType()) {
            case Array: {
                return "Array<" + (recursive ? AddressUtils.toString(((PdfArray)attribute).getAttributes(), false) : "") + ">";
            }
            case Boolean: 
            case Name: 
            case Null: 
            case Number: 
            case String: 
            case Unknown: 
            case IndirectReference: {
                String str = attribute.toString();
                if (str.length() > 20) {
                    str = str.substring(0, 17) + "...";
                }
                return str;
            }
            case Stream: {
                return "Stream<>";
            }
            case Dictionary: {
                return "Dictionary<" + (recursive ? AddressUtils.toString(((PdfDictionary)attribute).getAttributes(), false) : "") + ">";
            }
            case DictionaryAttribute: {
                return "DictionaryKey" + ((PdfDictionaryAttribute)attribute).getKey().toString();
            }
        }
        return "";
    }

    public String attributeToAddress(IPdfAttribute element) {
        return AddressUtils.coordinatesToAddress(this.pathToCoordinates(AddressUtils.attributeToPath(element)));
    }

    public AddressUtils(List<PdfIndirectObj> objects) {
        this.objects = objects;
    }

    @Override
    public IAddress getByOffset(long offset) {
        PdfIndirectObj attribute = this.offsetToAttribute(offset);
        return this.getAddress(attribute);
    }

    private PdfIndirectObj offsetToAttribute(long offset) {
        for (PdfIndirectObj obj : this.objects) {
            if (offset < (long)obj.getStartIndex() || offset > (long)obj.getEndIndex()) continue;
            return obj;
        }
        return null;
    }

    @Override
    public IAddress getByAddress(String address) {
        IPdfAttribute attribute = this.addressToAttribute(address);
        return this.getAddress(attribute, AddressUtils.addressToCoords(address));
    }

    protected IPdfAttribute addressToAttribute(String address) {
        List<Integer> coordinates = AddressUtils.addressToCoords(address);
        List<IPdfAttribute> attributes = this.coordinateToPath(coordinates);
        return attributes.get(attributes.size() - 1);
    }

    private IAddress getAddress(IPdfAttribute attribute) {
        List<Integer> coordinates = this.pathToCoordinates(AddressUtils.attributeToPath(attribute));
        if (attribute == null) {
            return AddressImpl.nullObject();
        }
        return this.getAddress(attribute, coordinates);
    }

    private IAddress getAddress(IPdfAttribute attribute, List<Integer> coordinates) {
        return new AddressImpl(AddressUtils.attributeToRange(attribute), AddressUtils.coordinatesToAddress(coordinates), this.coordinateToLabelAddress(coordinates), this.attributeToComment(attribute));
    }

    private static long[] attributeToRange(IPdfAttribute attribute) {
        long startIndex = 0L;
        long endIndex = 0L;
        if (attribute instanceof AbstractPdfParsableAttribute) {
            startIndex = ((AbstractPdfParsableAttribute)attribute).getStartIndex();
            endIndex = ((AbstractPdfParsableAttribute)attribute).getEndIndex();
        } else {
            startIndex = attribute.getParent().getStartIndex();
            endIndex = attribute.getParent().getEndIndex();
        }
        return new long[]{startIndex, endIndex - startIndex};
    }

    protected String coordinateToLabelAddress(List<Integer> coordinates) {
        List<IPdfAttribute> path = this.coordinateToPath(coordinates);
        StringBuilder address = new StringBuilder();
        address.append(((PdfIndirectObj)path.get(0)).getId().toString());
        block4: for (int i = 1; i < path.size(); ++i) {
            IPdfAttribute attribute = path.get(i);
            switch (attribute.getType()) {
                case IndirectObject: 
                case IndirectObjectStream: {
                    logger.error("Indirect objects are not displayed", new Object[0]);
                    continue block4;
                }
                case DictionaryAttribute: {
                    address.append(String.format("/<<%s>>", ((PdfDictionaryAttribute)attribute).getKey().toString()));
                    continue block4;
                }
                default: {
                    address.append(String.format("/[%d]", coordinates.get(i)));
                }
            }
        }
        return address.toString();
    }

    private String attributeToComment(IPdfAttribute attribute) {
        AbstractPdfParsableAttribute parent = attribute.getParent();
        if (parent == null) {
            return PdfFormatter.displayValue(attribute, null);
        }
        return PdfFormatter.displayValue(parent.getMainParent(), null);
    }

    @Override
    public INodeCoordinates addressToCoordinates(String address) {
        return new NodeCoordinates(AddressUtils.addressToCoords(address));
    }

    @Override
    public String coordinatesToAddress(INodeCoordinates coordinates) {
        return AddressUtils.coordinatesToAddress(coordinates.getPath());
    }
}

