/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderInfoFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private DataFrameView dfv;

    public CodeLoaderInfoFragment(Composite parent, int style, RcpClientContext context, ICodeObjectUnit unit) {
        super(parent, style, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        ILoaderInformation info = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation();
        if (info == null) {
            return;
        }
        this.dfv = this.buildSimple(this, "Field", "Value");
        this.dfv.getContextMenu().addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                CodeLoaderInfoFragment.this.addOperationsToContextMenu(menuMgr);
            }
        });
    }

    public ColumnViewer getViewer() {
        return this.dfv.getTableViewer();
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        ILoaderInformation info = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation();
        df.addRow("Processor", Strings.safe((Object)info.getTargetProcessor()));
        df.addRow(new Object[]{"Endianness", info.getEndianness()});
        df.addRow("Word Size", info.getWordSize() + " bits");
        df.addRow("Subsystem", Strings.safe((Object)info.getTargetSubsystem()));
        df.addRow("Version", info.getVersion());
        df.addRow("Flags", CodeLoaderInfoFragment.formatObjectFlags(info.getFlags()));
        long ts = info.getCompilationTimestamp();
        df.addRow("Compilation Time", ts == 0L ? "" : TimeFormatter.formatTimestampLocal(ts));
        df.addRow("Image Base", info.getImageBase());
        df.addRow("Image Size", info.getImageSize());
        df.addRow("Entry-Point", info.getEntryPoint());
        df.addRow("Overlay Offset", info.getOverlayOffset());
    }

    private static String formatObjectFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("SYMB ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 2) != 0) {
            sb.append("RELO ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("LIBR ");
            flags &= 0xFFFFFFFB;
        }
        if (flags != 0) {
            sb.append(String.format("(other:%Xh)", flags));
        }
        return sb.toString();
    }

    @Override
    public IItem getActiveItem() {
        int row;
        TableItem[] sel = this.dfv.getTable().getSelection();
        if (sel != null && sel.length == 1 && ((row = this.dfv.getSelectedRow()) == 7 || row == 9)) {
            return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel[0].getText(0), sel[0].getText(1), row != 7);
        }
        return null;
    }

    @Override
    public String getActiveAddress() {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return super.getActiveAddress();
    }
}

