/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractStaticTextFragment;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DescriptionFragment
extends AbstractStaticTextFragment<IUnit>
implements IContextMenu {
    private ViewerRefresher refresher;
    private IEventListener unitListener;

    public DescriptionFragment(Composite parent, int flags, RcpClientContext context, final IUnit unit) {
        super(parent, flags, context, unit);
        this.setLayout((Layout)new FillLayout());
        String description = unit.getDescription();
        final Document doc = new Document(description);
        TextViewer viewer = this.buildSimple(this, 768);
        this.refresher = new ViewerRefresher(parent.getDisplay(), viewer){

            @Override
            protected void performRefresh() {
                doc.set(unit.getDescription());
            }
        };
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (J.isUnitEvent(e)) {
                    DescriptionFragment.this.refresher.request();
                }
            }
        };
        unit.addListener(this.unitListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                unit.removeListener(DescriptionFragment.this.unitListener);
            }
        });
        viewer.setDocument(doc);
        Control ctl = viewer.getControl();
        context.getFontManager().registerWidget(ctl);
        new ContextMenu(viewer.getControl()).addContextMenu(this);
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        this.addOperationsToContextMenu(menuMgr);
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: {
                return true;
            }
        }
        return super.verifyOperation(req);
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case REFRESH: {
                this.refresher.request();
                return true;
            }
        }
        return super.doOperation(req);
    }
}

