/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import java.util.concurrent.Callable;

public class ActionStopAnalysisHandler
extends NativeCodeBaseHandler {
    public ActionStopAnalysisHandler() {
        super("stopAnalysis", "Interrupt the analysis", 0);
    }

    @Override
    public boolean canExecute() {
        if (!this.canExecuteAndNativeCheck(this.part, false)) {
            return false;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        if (pbcu == null) {
            return false;
        }
        return !pbcu.isAnalysisCompleted();
    }

    @Override
    public void execute() {
        final INativeCodeAnalyzer<?> gca = this.getNativeCodeUnit(this.part).getCodeAnalyzer();
        gca.requestAnalysisInterruption();
        boolean success = this.context.executeTaskWithPopupDelay(1000, "Please wait...", false, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                while (gca.isAnalyzing()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                return true;
            }
        });
        if (!success) {
            UI.error("Not interrupted!");
        }
        this.postExecute();
    }
}

