/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeEditDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Iterator;

public class ActionEditTypeHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionEditTypeHandler.class);
    boolean preferMethodProtoOverSignature = false;

    public ActionEditTypeHandler() {
        super("editType", S.s(495), 89);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true, true);
    }

    @Override
    public void execute() {
        int what;
        TextHistory historyData;
        String currentTypestr;
        long a;
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part, true);
        boolean allowMethodPrototypeAtEntryPointOnly = pbcu.getInternalMethod(a = this.getActiveMemoryAddress(this.part, pbcu, true), false) != null;
        INativeMethodItem m = pbcu.getInternalMethod(a, true);
        if (m != null) {
            if (this.preferMethodProtoOverSignature) {
                IPrototypeItem proto = m.getPrototype();
                currentTypestr = proto == null ? null : proto.getSignature(true);
                historyData = this.context.getTextHistoryData().get("nativePrototypesHistory");
                what = 1;
            } else {
                currentTypestr = m.getSignature(true);
                historyData = this.context.getTextHistoryData().get("nativeSignaturesHistory");
                what = 2;
            }
        } else if (!allowMethodPrototypeAtEntryPointOnly) {
            INativeType type = pbcu.getDataTypeAt(a);
            currentTypestr = type == null ? null : type.getSignature(true);
            historyData = this.context.getTextHistoryData().get("nativeTypesHistory");
            what = 0;
        } else {
            return;
        }
        NativeTypeEditDialog dlg = new NativeTypeEditDialog(this.getShell(), what, historyData);
        dlg.setInitialValue(currentTypestr);
        String typestr = dlg.open();
        if (typestr == null) {
            return;
        }
        if (what == 1) {
            boolean r = pbcu.setRoutinePrototype(m, typestr);
            if (!r) {
                logger.error("Failed to update signature of method %s (%Xh)", m.getName(true), a);
            }
        } else if (what == 2) {
            boolean r = pbcu.setRoutineSignature(m, typestr, false);
            if (!r) {
                logger.error("Failed to update prototype of method %s (%Xh)", m.getName(true), a);
            }
        } else if (what == 0) {
            ITypeManager typeman = pbcu.getTypeManager();
            INativeType t = typeman.getType(typestr);
            if (t == null && (t = Lists.getFirst(TypeUtil.findType(pbcu.getTypeManager().getTypes(), typestr, true))) == null) {
                ITypeLibrary typelib;
                Iterator<ITypeLibrary> iterator = pbcu.getTypeLibraryService().getLoadedTypeLibraries().iterator();
                while (iterator.hasNext() && (t = Lists.getFirst(TypeUtil.findType((typelib = iterator.next()).getTypes(), typestr, true))) == null) {
                }
            }
            if (t == null) {
                logger.error("Type not found: %s", typestr);
                return;
            }
            if (!pbcu.setDataTypeAt(a, t)) {
                logger.error("Failed to update type at address %Xh", a);
            }
        }
        this.postExecute();
    }
}

