/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.scripts;

import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.KeyShortcutsManager;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.GenericScriptHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptEntry;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptMetadata;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ScriptManager {
    private static final ILogger logger = GlobalLog.getLogger(ScriptManager.class);
    private Path dir;
    private WatchService watcher;
    private WatchKey key0;
    private Thread thread;
    private Map<File, ScriptEntry> scriptEntries = new ConcurrentHashMap<File, ScriptEntry>();

    public ScriptManager(File folder, boolean watch) throws IOException {
        this.dir = folder.toPath();
        this.scan();
        if (watch) {
            this.watcher = FileSystems.getDefault().newWatchService();
            try {
                this.key0 = this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                try {
                    this.watcher.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            this.thread = ThreadUtil.start(new Monitor());
        }
    }

    public synchronized void stop() {
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
            this.thread = null;
        }
        catch (InterruptedException e) {
            return;
        }
        try {
            this.key0.cancel();
        }
        finally {
            try {
                this.watcher.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void scan() {
        for (File file : IO.listFiles(this.dir.toFile())) {
            if (!file.isFile() || !file.getName().endsWith(".py")) continue;
            try {
                this.processFile(file, StandardWatchEventKinds.ENTRY_CREATE);
            }
            catch (Exception e) {
                logger.catching(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFile(File file, WatchEvent.Kind<?> kind) {
        if (!file.getName().endsWith(".py")) {
            return false;
        }
        logger.i("%s - %s", kind, file);
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.unregisterScript(file);
            return true;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));){
            String line;
            ScriptMetadata md = new ScriptMetadata();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (!line.startsWith("#")) break;
                if (!line.startsWith("#?")) continue;
                this.processScriptMetadata(file, line.substring(2).trim(), md);
            }
            this.registerScript(file, md);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean processScriptMetadata(File file, String s, ScriptMetadata md) {
        String pfx = "description=";
        if (s.startsWith(pfx)) {
            String value;
            md.description = value = s.substring(pfx.length()).trim();
            return true;
        }
        pfx = "author=";
        if (s.startsWith(pfx)) {
            String value;
            md.author = value = s.substring(pfx.length()).trim();
            return true;
        }
        pfx = "version=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            Version version = Version.parseFromString(value);
            if (version == null) {
                logger.error("Script %s: Invalid version number: %s", file, value);
                return false;
            }
            md.version = version;
            return true;
        }
        pfx = "shortcut=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            int shortcut = KeyShortcutsManager.parseShortcut(value);
            if (shortcut == 0) {
                logger.error("Script %s: Invalid keyboard shortcut: %s", file, value);
                return false;
            }
            md.shortcut = shortcut;
            return true;
        }
        logger.warn("Unknown script metadata: '%s'", s);
        return false;
    }

    private void registerScript(File file, ScriptMetadata md) {
        final ScriptEntry entry = new ScriptEntry(file, md);
        final ScriptEntry previousEntry = this.scriptEntries.get(file);
        if (entry.equals(previousEntry)) {
            return;
        }
        final RcpClientContext ctx = RcpClientContext.getInstance();
        if (ctx != null) {
            UIExecutor.sync(ctx.getDisplay(), new Runnable(){

                @Override
                public void run() {
                    if (previousEntry != null && previousEntry.handler != null) {
                        ctx.getKeyAccelaratorManager().unregisterHandler(previousEntry.handler);
                    }
                    GenericScriptHandler handler = new GenericScriptHandler(entry);
                    ctx.getKeyAccelaratorManager().registerHandler(handler);
                    entry.handler = handler;
                }
            });
        }
        this.scriptEntries.put(entry.file, entry);
    }

    private void unregisterScript(File file) {
        final ScriptEntry entry = this.scriptEntries.remove(file);
        if (entry == null) {
            return;
        }
        final RcpClientContext ctx = RcpClientContext.getInstance();
        if (ctx != null) {
            UIExecutor.sync(ctx.getDisplay(), new Runnable(){

                @Override
                public void run() {
                    if (entry.handler != null) {
                        ctx.getKeyAccelaratorManager().unregisterHandler(entry.handler);
                    }
                }
            });
        }
    }

    public List<GenericScriptHandler> getScriptHandlers() {
        ArrayList<GenericScriptHandler> r = new ArrayList<GenericScriptHandler>();
        for (ScriptEntry e : this.scriptEntries.values()) {
            if (e.handler == null) continue;
            r.add(e.handler);
        }
        return r;
    }

    public String toString() {
        return String.format("ScriptManager[folder=%s]", this.dir);
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            block7: {
                WatchKey key;
                boolean valid;
                do {
                    try {
                        key = ScriptManager.this.watcher.take();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!Thread.interrupted()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                            WatchEvent<?> ev = event;
                            Path filename = (Path)ev.context();
                            File file = ScriptManager.this.dir.resolve(filename).toFile();
                            if (!file.getName().endsWith(".py")) continue;
                            try {
                                ScriptManager.this.processFile(file, kind);
                            }
                            catch (Exception e) {
                                logger.catching(e);
                            }
                            continue;
                        }
                        break block7;
                    }
                } while (valid = key.reset());
            }
        }
    }
}

