/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.DbgAttachDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebuggerAttachHandler
extends DebuggerBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(DebuggerAttachHandler.class);

    public DebuggerAttachHandler() {
        super("dbgAttach", S.s(570), null, "eclipse/debug_view.png", 0);
    }

    @Override
    public boolean canExecute() {
        IDebuggerUnit dbg = this.getCurrentDebugger(this.part);
        return (dbg == null || !dbg.isAttached()) && this.canAttachDebugger(this.part);
    }

    @Override
    public void execute() {
        IUnit unit = this.getCurrentUnit(this.part);
        if (unit == null) {
            String msg = "You must first load an artifact before starting a debugging.\n\n(This limitation will be lifted in the future.)";
            UI.warn(msg);
            return;
        }
        this.context.getTelemetry().record("handlerAttachDebugger", "targetUnitType", unit.getFormatType());
        DbgAttachDialog dlg = new DbgAttachDialog(this.getShell(), this.context, null, unit);
        final DbgAttachDialog.DbgAttachInfo result = dlg.open();
        if (result == null) {
            return;
        }
        AtomicBoolean createdByHandler = new AtomicBoolean();
        final IDebuggerUnit dbg = this.createDebuggerFor(unit, createdByHandler);
        if (dbg == null) {
            UI.warn("No debugger available");
            return;
        }
        if (!HandlerUtil.processUnit(this.getShell(), this.context, dbg, false)) {
            UI.warn("The debugger was not set up properly");
            if (createdByHandler.get() && dbg.getParent() instanceof IUnit) {
                ((IUnit)dbg.getParent()).removeChild(dbg);
            }
            return;
        }
        final StringBuilder stb = new StringBuilder();
        boolean success = Booleans.toBoolean(this.context.executeTask("Attaching to target...", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return dbg.attach(result.info);
                }
                catch (Exception e) {
                    logger.catching(e);
                    stb.append(e.getMessage());
                    return false;
                }
            }
        }));
        if (!success) {
            if (stb.length() != 0) {
                stb.insert(0, ":\n\n");
            }
            UI.error("Could not attach to target" + stb.toString());
            dbg.detach();
            if (createdByHandler.get() && dbg.getParent() instanceof IUnit) {
                ((IUnit)dbg.getParent()).removeChild(dbg);
            }
            return;
        }
        this.restoreUIBreakpoints(dbg);
        this.context.setDebuggingMode(true);
        PartManager pman = this.context.getPartManager();
        pman.create(dbg, true);
        List<? extends IUnit> children = dbg.getChildren();
        for (IUnit iUnit : children) {
            if (!(iUnit instanceof IDebuggerUnit)) continue;
            pman.create(iUnit, true);
        }
    }

    private IDebuggerUnit createDebuggerFor(IUnit unit, AtomicBoolean createdByHandler) {
        IDebuggerUnit dbg = HandlerUtil.getCurrentDebugger(this.context, unit);
        if (dbg == null) {
            while (unit != null) {
                dbg = unit.getUnitProcessor().createDebugger("", unit);
                createdByHandler.set(true);
                if (dbg != null || !(unit.getParent() instanceof IUnit)) break;
                unit = (IUnit)unit.getParent();
            }
        }
        return dbg;
    }
}

