/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphPlaceholder;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractLocalGraphFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class ActionGenerateGraphHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionGenerateGraphHandler.class);

    public ActionGenerateGraphHandler() {
        super("graph", "Graph", 0, "Generate a visual graph for the current item (eg, CFG for a routine)", "eclipse/all_sc_obj.png", 32);
    }

    @Override
    public boolean canExecute() {
        UnitPartManager manager = this.context.getPartManager().getUnitPartManager(this.part);
        if (manager == null) {
            return false;
        }
        IUnitFragment activeView = manager.getActiveFragment();
        if (!(activeView instanceof TextFragment) && !(activeView instanceof AbstractLocalGraphFragment)) {
            return false;
        }
        IUnit unit = manager.getUnit();
        return unit instanceof ICodeUnit || unit instanceof INativeSourceUnit;
    }

    @Override
    public void execute() {
        this.context.getTelemetry().record("actionGraph");
        UnitPartManager manager = this.context.getPartManager().getUnitPartManager(this.part);
        if (manager == null) {
            return;
        }
        IUnitFragment activeView = manager.getActiveFragment();
        if (activeView == null) {
            return;
        }
        AbstractLocalGraphFragment graphView = manager.getFragmentByType(AbstractLocalGraphFragment.class);
        if (graphView == null) {
            return;
        }
        String address = ActionGenerateGraphHandler.getActiveAddress(this.part);
        if (address == null) {
            return;
        }
        if (activeView != graphView) {
            if (!graphView.canDisplayAtAddress(address)) {
                logger.warn("Cannot display graph at address: %s", address);
                return;
            }
            String msg = GraphPlaceholder.standardHepMessage;
            UI.popupOptional(this.getShell(), 0, "Graph View", msg, "dlgGraphView");
            try {
                manager.setActiveFragment(graphView);
                graphView.setActiveAddress(address, null, false);
            }
            catch (RuntimeException e) {
                if (Licensing.isDebugBuild()) {
                    throw e;
                }
                String details = String.format("requested_address=%s", address);
                this.context.getErrorHandler().processThrowable(e, false, false, false, details, null, (IUnit)graphView.getUnit());
                UI.error("An error occurred when generating the graph.");
            }
        } else {
            TextFragment codeView = manager.getFragmentByType(TextFragment.class);
            if (codeView == null) {
                return;
            }
            manager.setActiveFragment(codeView);
            codeView.setActiveAddress(address, null, false);
        }
    }
}

