/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayLogicalGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.VirtualArrayGroup;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractArrayGroupFilteredTreeContentProvider
implements IFilteredTreeContentProvider {
    public static final int DEFAULT_LIMIT = 1000;
    public static final int DEFAULT__GROUP_LIMIT = 100;
    public static final int DEFAULT_PERFORMANCE_LIMIT = 20;
    private static final int MIN_GROUP_SIZE_ALLOWED = 10;
    private int limit;
    private int groupLimit;
    private int performanceLimit;
    private boolean performanceOptimizer = false;
    private Map<Integer, Map<Integer, Map<Object, ArrayGroup>>> arrayGroups = new HashMap<Integer, Map<Integer, Map<Object, ArrayGroup>>>();
    private Map<Integer, Map<Integer, Map<Object, ArrayLogicalGroup>>> arrayLogicalGroups = new HashMap<Integer, Map<Integer, Map<Object, ArrayLogicalGroup>>>();
    private Map<Integer, Map<Object, VirtualArrayGroup>> virtualElements = new HashMap<Integer, Map<Object, VirtualArrayGroup>>();

    public AbstractArrayGroupFilteredTreeContentProvider(int limit, int groupLimit, int performanceLimit) {
        this.limit = limit;
        this.groupLimit = groupLimit;
        this.performanceLimit = performanceLimit;
    }

    public AbstractArrayGroupFilteredTreeContentProvider() {
        this(1000, 100, 20);
    }

    protected ArrayGroup getArrayGroup(Object parentElement, int firstIndex, int toplevel) {
        ArrayGroup g;
        Map<Object, ArrayGroup> gr;
        Map<Integer, Map<Object, ArrayGroup>> lev = this.arrayGroups.get(toplevel);
        if (lev == null) {
            lev = new HashMap<Integer, Map<Object, ArrayGroup>>();
            this.arrayGroups.put(toplevel, lev);
        }
        if ((gr = lev.get(firstIndex)) == null) {
            gr = new HashMap<Object, ArrayGroup>();
            lev.put(firstIndex, gr);
        }
        if ((g = gr.get(parentElement)) == null) {
            g = new ArrayGroup(firstIndex);
            gr.put(parentElement, g);
        }
        g.getChildren().clear();
        return g;
    }

    protected ArrayLogicalGroup getArrayLogicalGroup(Object parentElement, int firstIndex, String groupName, boolean packaged, int toplevel) {
        ArrayLogicalGroup g;
        Map<Object, ArrayLogicalGroup> gr;
        Map<Integer, Map<Object, ArrayLogicalGroup>> lev = this.arrayLogicalGroups.get(toplevel);
        if (lev == null) {
            lev = new HashMap<Integer, Map<Object, ArrayLogicalGroup>>();
            this.arrayLogicalGroups.put(toplevel, lev);
        }
        if ((gr = lev.get(firstIndex)) == null) {
            gr = new HashMap<Object, ArrayLogicalGroup>();
            lev.put(firstIndex, gr);
        }
        if ((g = gr.get(parentElement)) == null || !Strings.equals(g.getGroupName(), groupName) || g.isPackaged() != packaged) {
            g = new ArrayLogicalGroup(firstIndex, groupName, packaged);
            gr.put(parentElement, g);
        }
        g.getChildren().clear();
        return g;
    }

    protected VirtualArrayGroup getVirtualElement(Object elt, int firstIndex, String label) {
        VirtualArrayGroup g;
        Map<Object, VirtualArrayGroup> gr = this.virtualElements.get(firstIndex);
        if (gr == null) {
            gr = new HashMap<Object, VirtualArrayGroup>();
            this.virtualElements.put(firstIndex, gr);
        }
        if ((g = gr.get(elt)) == null || !Strings.equals(g.getGroupName(), label)) {
            g = new VirtualArrayGroup(firstIndex, elt, label);
            gr.put(elt, g);
        }
        g.getChildren().clear();
        return g;
    }

    @Override
    public final boolean hasChildren(Object element) {
        if (element instanceof IArrayGroup) {
            if (((IArrayGroup)element).isSingle()) {
                return this.hasChildren(((IArrayGroup)element).getFirstElement());
            }
            return true;
        }
        return this.hasChildren2(element);
    }

    public abstract boolean hasChildren2(Object var1);

    @Override
    public final Object[] getChildren(Object parentElement) {
        List<Object> children;
        if (parentElement instanceof IArrayGroup) {
            if (((IArrayGroup)parentElement).isSingle()) {
                parentElement = ((IArrayGroup)parentElement).getFirstElement();
            } else {
                return ((ArrayGroup)parentElement).getChildren().toArray();
            }
        }
        if ((children = this.getChildren2(parentElement)) == null) {
            return null;
        }
        if (this.limit < 10) {
            return children.toArray();
        }
        Object[] elts = children.toArray();
        this.sort(elts);
        children = Arrays.asList(elts);
        return this.noMoreThanNChildren(children, parentElement);
    }

    private Object[] noMoreThanNChildren(List<?> r, Object parentElement) {
        if (this.performanceOptimizer && r.size() >= this.performanceLimit || r.size() > this.limit) {
            if (!this.performanceOptimizer) {
                this.performanceOptimizer = true;
                this.onFirstOptimization(r);
            }
            ArrayList<IArrayGroup> groups = new ArrayList<IArrayGroup>();
            Map<Integer, ArrayLogicalGroup> logicalGroups = this.getLogicalGroups(r, parentElement);
            int logicalGroupSize = this.getLogicalGroupSize(logicalGroups);
            if (r.size() <= this.limit) {
                if (logicalGroups.size() == 0) {
                    return r.toArray();
                }
                if (logicalGroups.size() == 1 && r.size() - logicalGroupSize < this.performanceLimit) {
                    return r.toArray();
                }
            }
            ArrayGroup currentGroup = null;
            boolean shouldCreateIntermediateGroups = r.size() - logicalGroupSize > this.limit;
            for (int i = 0; i < r.size(); ++i) {
                ArrayLogicalGroup logicalGroup;
                if (!logicalGroups.isEmpty() && (logicalGroup = logicalGroups.get(i)) != null) {
                    currentGroup = null;
                    groups.add(logicalGroup);
                    i += logicalGroup.size() - 1;
                    continue;
                }
                if (shouldCreateIntermediateGroups && (currentGroup == null || currentGroup.size() >= this.getGroupLimit())) {
                    currentGroup = this.getArrayGroup(parentElement, i, 0);
                    groups.add(currentGroup);
                }
                if (currentGroup != null) {
                    currentGroup.add(r.get(i));
                    continue;
                }
                groups.add(this.getVirtualElement(r.get(i), i, null));
            }
            if (shouldCreateIntermediateGroups && logicalGroupSize > 0) {
                List<Integer> groupsBySize;
                int flattenedElements = this.limit - groups.size() % this.limit;
                while (flattenedElements != this.limit && flattenedElements > 0 && !(groupsBySize = this.getSmallestGroups(groups)).isEmpty()) {
                    int index;
                    for (int j = groupsBySize.size() - 1; j >= 0 && (flattenedElements -= ((IArrayGroup)groups.get(index = groupsBySize.get(j).intValue())).size()) >= 0; --j) {
                        IArrayGroup g = (IArrayGroup)groups.remove(index);
                        for (int k = 0; k < g.size(); ++k) {
                            groups.add(index + k, new VirtualArrayGroup(g.getFirstElementIndex() + k, g.getChildren().get(k)));
                        }
                    }
                }
            }
            return this.noMoreThanNChildrenGroup(groups, parentElement, 1);
        }
        return r.toArray();
    }

    private List<Integer> getSmallestGroups(List<IArrayGroup> groups) {
        int minSize = -1;
        ArrayList<Integer> subGroups = new ArrayList<Integer>();
        for (int i = 1; i < groups.size(); ++i) {
            int size;
            IArrayGroup g = groups.get(i);
            if (g instanceof ArrayLogicalGroup || (size = g.size()) == 1) continue;
            if (size < minSize || minSize == -1) {
                minSize = size;
                subGroups.clear();
                subGroups.add(i);
                continue;
            }
            if (size != minSize) continue;
            subGroups.add(i);
        }
        return subGroups;
    }

    private int getLogicalGroupSize(Map<Integer, ArrayLogicalGroup> logicalGroups) {
        int size = 0;
        if (logicalGroups == null || logicalGroups.size() == 0) {
            return size;
        }
        for (ArrayLogicalGroup g : logicalGroups.values()) {
            size += g.size();
        }
        return size;
    }

    private Object[] noMoreThanNChildrenGroup(List<IArrayGroup> r, Object parentElement, int toplevel) {
        if (this.groupLimit < 10) {
            return r.toArray();
        }
        if (r.size() > this.limit) {
            ArrayList<IArrayGroup> groups = new ArrayList<IArrayGroup>();
            ArrayGroup currentGroup = null;
            for (int i = 0; i < r.size(); ++i) {
                if (currentGroup == null || currentGroup.size() >= this.groupLimit) {
                    currentGroup = this.getArrayGroup(parentElement, r.get(i).getFirstElementIndex(), toplevel);
                    groups.add(currentGroup);
                }
                currentGroup.add(r.get(i));
            }
            return this.noMoreThanNChildrenGroup(groups, parentElement, toplevel + 1);
        }
        return r.toArray();
    }

    public Map<Integer, ArrayLogicalGroup> getLogicalGroups(List<?> r, Object parentElement) {
        return new HashMap<Integer, ArrayLogicalGroup>();
    }

    public abstract List<?> getChildren2(Object var1);

    public abstract void sort(Object[] var1);

    public void onFirstOptimization(List<?> r) {
    }

    public static String getStringAt(Object element, int index) {
        if (element instanceof IArrayGroup) {
            IArrayGroup v = (IArrayGroup)element;
            if (index == 0) {
                return String.format("[%d..%d]", v.getFirstElementIndex(), v.getLastElementIndex());
            }
        }
        return null;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getGroupLimit() {
        return this.groupLimit < 10 ? this.limit : this.groupLimit;
    }
}

