/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.state;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.util.IPersistenceProvider;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class WidgetWrapper {
    private static final ILogger logger = GlobalLog.getLogger(WidgetWrapper.class);
    private IPersistenceProvider pp;

    public WidgetWrapper(IPersistenceProvider pp) {
        if (pp == null) {
            throw new IllegalArgumentException("The persistence provider is null");
        }
        this.pp = pp;
    }

    public boolean wrap(Control ctl) {
        int id = UIUtil.getWidgetId(ctl);
        if (id == 0) {
            logger.debug("The widget '%s' has a null id and cannot be wrapped", ctl);
            return false;
        }
        this.wrapInternal("" + id, ctl);
        return true;
    }

    private void wrapInternal(String fqn, Control ctl) {
        if (ctl instanceof Table) {
            this.monitorTable(fqn, (Table)ctl);
        }
        if (ctl instanceof Tree) {
            this.monitorTree(fqn, (Tree)ctl);
        }
        if (ctl instanceof Composite) {
            int i = 0;
            for (Control ctl1 : ((Composite)ctl).getChildren()) {
                this.wrapInternal(fqn + "/@" + i, ctl1);
                ++i;
            }
        }
    }

    void monitorTable(final String fqn, Table table) {
        final TableColumnManager t = new TableColumnManager(table);
        this.restore(fqn, t);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetWrapper.this.record(fqn, t);
            }
        });
    }

    void monitorTree(final String fqn, Tree tree) {
        final TreeColumnManager t = new TreeColumnManager(tree);
        this.restore(fqn, t);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetWrapper.this.record(fqn, t);
            }
        });
    }

    void restore(String fqn, IColumnWidgetManager t) {
        logger.i("Restoring state for widget %s", fqn);
        String encodedData = this.pp.load(fqn);
        if (encodedData != null) {
            try {
                String[] elts = encodedData.split(",");
                if (elts.length == t.getCount()) {
                    String[] v;
                    int i;
                    int[] order = new int[elts.length];
                    int[] widths = new int[elts.length];
                    for (i = 0; i < elts.length && (v = elts[i].split(":")).length == 2; ++i) {
                        order[i] = Integer.parseInt(v[0]);
                        widths[i] = Integer.parseInt(v[1]);
                    }
                    t.setOrder(order);
                    for (i = 0; i < widths.length; ++i) {
                        t.setWidth(i, widths[i]);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                logger.trace("Invalid widget persistence data: %s", e);
            }
        }
    }

    void record(String fqn, IColumnWidgetManager t) {
        logger.i("Recording state for widget %s", fqn);
        int count = t.getCount();
        if (count >= 1) {
            StringBuilder sb = new StringBuilder();
            int[] order = t.getOrder();
            for (int i = 0; i < count; ++i) {
                if (i >= 1) {
                    sb.append(',');
                }
                int index = order[i];
                int w = t.getWidth(index);
                sb.append(String.format("%d:%d", index, w));
            }
            String encodedState = sb.toString();
            this.pp.save(fqn, encodedState);
        }
    }

    static class TreeColumnManager
    implements IColumnWidgetManager {
        private Tree t;

        public TreeColumnManager(Tree t) {
            this.t = t;
        }

        @Override
        public int getCount() {
            return this.t.getColumnCount();
        }

        @Override
        public int[] getOrder() {
            return this.t.getColumnOrder();
        }

        @Override
        public void setOrder(int[] order) {
            this.t.setColumnOrder(order);
        }

        @Override
        public int getWidth(int index) {
            return this.t.getColumn(index).getWidth();
        }

        @Override
        public void setWidth(int index, int width) {
            this.t.getColumn(index).setWidth(width);
        }
    }

    static class TableColumnManager
    implements IColumnWidgetManager {
        private Table t;

        public TableColumnManager(Table t) {
            this.t = t;
        }

        @Override
        public int getCount() {
            return this.t.getColumnCount();
        }

        @Override
        public int[] getOrder() {
            return this.t.getColumnOrder();
        }

        @Override
        public void setOrder(int[] order) {
            this.t.setColumnOrder(order);
        }

        @Override
        public int getWidth(int index) {
            return this.t.getColumn(index).getWidth();
        }

        @Override
        public void setWidth(int index, int width) {
            this.t.getColumn(index).setWidth(width);
        }
    }

    static interface IColumnWidgetManager {
        public int getCount();

        public int[] getOrder();

        public void setOrder(int[] var1);

        public int getWidth(int var1);

        public void setWidth(int var1, int var2);
    }
}

