/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnimatedGif
extends Canvas {
    private final ImageLoader loader = new ImageLoader();
    private Display display;
    private int img;
    private volatile boolean animating;
    private Thread thread;

    public AnimatedGif(Composite parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
    }

    public void load(InputStream resource) {
        this.loader.load(resource);
    }

    public void animate() {
        if (this.thread == null) {
            this.thread = this.createThread();
            this.thread.setDaemon(true);
        }
        if (this.thread.isAlive()) {
            return;
        }
        this.thread.start();
    }

    public void stop() {
        this.animating = false;
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Thread createThread() {
        return new Thread(){
            long currentTime = System.currentTimeMillis();

            @Override
            public void run() {
                AnimatedGif.this.animating = true;
                while (AnimatedGif.this.animating) {
                    AnimatedGif.this.img = AnimatedGif.this.img == ((AnimatedGif)AnimatedGif.this).loader.data.length - 1 ? 0 : AnimatedGif.this.img + 1;
                    int delayTime = Math.max(50, 10 * ((AnimatedGif)AnimatedGif.this).loader.data[((AnimatedGif)AnimatedGif.this).img].delayTime);
                    long now = System.currentTimeMillis();
                    long ms = Math.max(this.currentTime + (long)delayTime - now, 5L);
                    this.currentTime += (long)delayTime;
                    try {
                        Thread.sleep(ms);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (AnimatedGif.this.display.isDisposed()) continue;
                    AnimatedGif.this.display.syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            GC gc = null;
                            Image frameImage = null;
                            try {
                                gc = new GC((Drawable)AnimatedGif.this);
                                ImageData nextFrameData = ((AnimatedGif)AnimatedGif.this).loader.data[AnimatedGif.this.img];
                                frameImage = new Image((Device)AnimatedGif.this.display, nextFrameData);
                                gc.drawImage(frameImage, nextFrameData.x, nextFrameData.y);
                            }
                            catch (SWTException sWTException) {
                            }
                            finally {
                                if (frameImage != null && !frameImage.isDisposed()) {
                                    frameImage.dispose();
                                }
                                if (gc != null && !gc.isDisposed()) {
                                    gc.dispose();
                                }
                            }
                        }
                    });
                }
                AnimatedGif.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GC gc = null;
                        try {
                            gc = new GC((Drawable)AnimatedGif.this);
                            gc.fillRectangle(0, 0, AnimatedGif.this.getBounds().width, AnimatedGif.this.getBounds().height);
                        }
                        finally {
                            if (gc != null && !gc.isDisposed()) {
                                gc.dispose();
                            }
                        }
                    }
                });
            }
        };
    }
}

