/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParser;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.HistoryAssistedTextField;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NativeTypeEditDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypeEditDialog.class);
    private int what;
    private String strTT;
    private String strTTs;
    private TextHistory textHistory;
    private HistoryAssistedTextField hatf;
    private String input;
    private String description;
    private String initialValue;
    private boolean preparsingFailed;

    public NativeTypeEditDialog(Shell parent, int what, TextHistory textHistory) {
        super(parent, "Edit a type", true, true, "nativeTypeEditDialog");
        this.scrolledContainer = true;
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.what = what;
        switch (what) {
            case 0: {
                this.strTT = "type";
                break;
            }
            case 1: {
                this.strTT = "prototype";
                break;
            }
            case 2: {
                this.strTT = "signature";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.strTTs = this.strTT + "s";
        this.textHistory = textHistory;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public String open() {
        super.open();
        return this.input;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        Label hint = new Label(parent, 64);
        hint.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        if (this.description == null) {
            this.description = "Input the desired " + this.strTT + ":";
        }
        hint.setText(this.description);
        this.hatf = new HistoryAssistedTextField(parent, S.s(779) + ":\t", this.textHistory, true);
        this.hatf.setLayoutData(UIUtil.createGridDataFillHorizontally());
        if (this.initialValue != null) {
            this.hatf.getWidget().setText(this.initialValue);
            this.hatf.getWidget().forceFocus();
            if (!OSType.determine().isWindows()) {
                this.hatf.getWidget().selectAll();
            } else {
                parent.getDisplay().timerExec(5, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NativeTypeEditDialog.this.hatf.selectAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        UIUtil.disableTabOutput((Control)this.hatf);
        Composite c1 = new Composite(parent, 0);
        c1.setLayout((Layout)new FillLayout());
        c1.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        final Label preparsingHint = new Label(c1, 64);
        preparsingHint.setText("< pre-parsing result >");
        this.hatf.getWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String hint;
                NativeTypeEditDialog.this.preparsingFailed = false;
                String s = NativeTypeEditDialog.this.hatf.getText();
                if (Strings.isBlank(s) || NativeTypeEditDialog.this.initialValue != null && s.equals(NativeTypeEditDialog.this.initialValue)) {
                    hint = "< pre-parsing result >";
                } else {
                    try {
                        TypeStringParser.verify(s, true);
                        hint = "The input " + NativeTypeEditDialog.this.strTT + " looks correct, you may apply it.";
                    }
                    catch (TypeStringParseException e1) {
                        hint = "Invalid " + NativeTypeEditDialog.this.strTT + "!";
                        NativeTypeEditDialog.this.preparsingFailed = true;
                    }
                }
                preparsingHint.setText(hint);
            }
        });
        this.createButtons(parent, 0x10000120, 32);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            if (this.preparsingFailed) {
                UI.warn("The input " + this.strTT + " is incorrect!");
                return;
            }
            this.hatf.confirm();
            this.input = this.hatf.getText();
            this.shell.close();
        } else if (buttonId == 0x10000000) {
            String msg = "";
            if (this.what == 1) {
                msg = "Format:\n    <calling-convention> return-type ([param1-type[, param2-type[, ...]]])\n\nExamples:\n    void()\n    int()\n    int(void)\n    int(unsigned int)\n    unsigned char * (UINT32, char x)\n    char* __cdecl (int, double)\n    <__stdcall> char* (int, double)\n    <__o32> int ()\n";
            } else if (this.what == 0) {
                msg = "IMPORTANT: Array types are not supported in this widget!\nTo apply an array type, first apply the non-array type, then use the 'Edit array' command (keyboard: '*') and specify the array size.\n\nFormat:\n  type-spec\n\nExamples:\n  int\n  unsigned int\n  UINT32 *\n";
            } else if (this.what == 2) {
                msg = "Format:\n    return-type [calling-convention] [attributes] routine-name([type1 name1[, type2 name2[, ...]]])\n\nExamples:\n    void __cdecl f()\n    void f(void)\n    void f(int a)\n    void f(unsigned, unsigned int *)\n    void f(int a, void __cdecl (*pf[4])(int a))\n    void f(int a, ...)\n    void f(int a[3])\n    void __attribute__((noreturn)) exit(int code)\n    void __cdecl __declspec(noreturn) exit(int)\n";
            }
            UI.info(this.shell, "Help for native " + this.strTTs, msg);
        } else {
            this.shell.close();
        }
    }
}

