/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchResolution;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.InstructionHints;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParser;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeRoutineChooserDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditInstructionDialog
extends JebDialog {
    private long address;
    private INativeCodeUnit<?> unit;
    private boolean confirmed;
    INativeInstructionItem ii;
    Text widgetAddress;
    Text widgetLabel;
    Text widgetBytes;
    Text widgetDisas;
    Text widgetHintSPDelta;
    Text widgetHintProto;
    Text widgetDynTarget;
    private static final String KEY_DYNTARGET = "dynTargetItem";

    public EditInstructionDialog(Shell parent, long address, INativeCodeUnit<?> unit) {
        super(parent, "Edit the Instruction", true, true);
        this.scrolledContainer = true;
        this.address = address;
        this.unit = unit;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.confirmed;
    }

    @Override
    protected void createContents(final Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        new Label(parent, 0).setText(S.s(52) + ": ");
        this.widgetAddress = UIUtil.createTextboxInGrid(parent, 2060, 50, 1, true, false);
        new Label(parent, 0).setText(S.s(424) + ": ");
        this.widgetLabel = new Text(parent, 2060);
        this.widgetLabel.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label(parent, 0).setText("Bytes: ");
        this.widgetBytes = new Text(parent, 2060);
        this.widgetBytes.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label(parent, 0).setText("Disassembly: ");
        this.widgetDisas = new Text(parent, 2060);
        this.widgetDisas.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Group grp = UIUtil.createGroupGrid(parent, "Attributes", 2, 2);
        new Label((Composite)grp, 0).setText("SP Delta: ");
        this.widgetHintSPDelta = new Text((Composite)grp, 2052);
        this.widgetHintSPDelta.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label((Composite)grp, 0).setText("Prototype Hint: ");
        this.widgetHintProto = new Text((Composite)grp, 2052);
        this.widgetHintProto.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label((Composite)grp, 0).setText("Dynamic Target: ");
        Composite c = UIUtil.createCompositeGrid((Composite)grp, 1, 3);
        UIUtil.createTightPushbox(c, "Select", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                INativeMethodItem routine = new NativeRoutineChooserDialog(parent.getShell(), EditInstructionDialog.this.unit).open();
                if (routine != null) {
                    EditInstructionDialog.this.setDynTargetWidget(routine);
                }
            }
        });
        UIUtil.createTightPushbox(c, "Clear", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditInstructionDialog.this.setDynTargetWidget(null);
            }
        });
        this.widgetDynTarget = new Text(c, 2060);
        this.widgetDynTarget.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.loadInstruction(this.address);
        this.createOkayCancelButtons(parent);
    }

    private boolean loadInstruction(long address) {
        IBranchTarget target;
        this.widgetAddress.setText("");
        this.widgetLabel.setText("");
        this.widgetBytes.setText("");
        this.widgetDisas.setText("");
        this.widgetHintSPDelta.setText("");
        this.widgetHintProto.setText("");
        this.setDynTargetWidget(null);
        this.ii = null;
        INativeContinuousItem item = this.unit.getNativeItemAt(address);
        if (!(item instanceof INativeInstructionItem)) {
            return false;
        }
        this.ii = (INativeInstructionItem)item;
        this.widgetAddress.setText(Strings.safe(this.ii.getAddress()));
        this.widgetLabel.setText(Strings.safe(this.ii.getLabel()));
        this.widgetBytes.setText(Formatter.formatBinaryLine(this.ii.getInstruction().getCode()));
        this.widgetDisas.setText(this.ii.getInstruction().format(this.ii.getMemoryAddress()));
        InstructionHints hints = this.ii.getHints(false);
        if (hints != null) {
            this.widgetHintSPDelta.setText(Strings.safe(hints.getStackPointerDelta()));
            this.widgetHintProto.setText(Strings.safe(hints.getCallsitePrototype()));
        }
        if ((target = this.getCurrentlyStoredResolvedTarget()) != null) {
            this.setDynTargetWidget(target.getRoutine());
        }
        return true;
    }

    private IBranchTarget getCurrentlyStoredResolvedTarget() {
        IBranchResolution reso = this.unit.getCodeModel().getDynamicBranchResolution(this.address);
        return reso.isEmpty() ? null : reso.getResolvedTarget();
    }

    private void setDynTargetWidget(INativeMethodItem routine) {
        if (routine == null) {
            this.widgetDynTarget.setText("");
        } else {
            this.widgetDynTarget.setText(routine.getName(true));
        }
        this.widgetDynTarget.setData(KEY_DYNTARGET, (Object)routine);
    }

    @Override
    protected void onConfirm() {
        INativeMethodItem routine;
        this.confirmed = true;
        String text = this.widgetHintSPDelta.getText().trim();
        if (text.isEmpty()) {
            if (this.ii.getHints(false) != null) {
                this.ii.getHints(true).setStackPointerDelta(null);
            }
        } else {
            try {
                int spdelta = Integer.parseInt(text);
                this.ii.getHints(true).setStackPointerDelta(spdelta);
            }
            catch (NumberFormatException e) {
                UI.error("Cannot parse integer value for SP delta");
                return;
            }
        }
        if ((text = this.widgetHintProto.getText().trim()).isEmpty()) {
            if (this.ii.getHints(false) != null) {
                this.ii.getHints(true).setCallsitePrototype(null);
            }
        } else {
            try {
                IPrototypeItem proto = new TypeStringParser(this.unit.getTypeManager()).parseSignature(text, true);
                this.ii.getHints(true).setCallsitePrototype(proto);
            }
            catch (TypeStringParseException e) {
                UI.error("Cannot parse signature. The expected format is:\n\nreturnType [callingConvention] f([param1Type[, param2Type[, ...]]])");
                return;
            }
        }
        if ((routine = (INativeMethodItem)this.widgetDynTarget.getData(KEY_DYNTARGET)) == null) {
            IBranchTarget current = this.getCurrentlyStoredResolvedTarget();
            if (current != null) {
                this.unit.getCodeAnalyzer().unrecordDynamicBranchTarget(this.address, true, current);
            }
        } else {
            this.unit.getCodeAnalyzer().recordDynamicBranchTarget(this.address, true, new BranchTarget(routine), false);
        }
        super.onConfirm();
    }
}

