/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.StringType;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.StringSetupInformation;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DefineStringDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(DefineStringDialog.class);
    private long address;
    private INativeCodeUnit<?> unit;
    private boolean confirmed;
    private StringSetupInformation info = new StringSetupInformation();
    private Label widgetInfo;
    private Text widgetAddress;
    private Text widgetMinCount;
    private Text widgetMaxCount;
    private Combo widgetStringTypes;
    private Button widgetOk;

    public DefineStringDialog(Shell parent, long address, INativeCodeUnit<?> unit) {
        super(parent, "Define String", true, true);
        this.scrolledContainer = true;
        this.address = address;
        this.unit = unit;
    }

    @Override
    public StringSetupInformation open() {
        super.open();
        if (!this.confirmed) {
            return null;
        }
        return this.info;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 4);
        this.widgetInfo = new Label(parent, 0);
        this.widgetInfo.setText("N/A");
        this.widgetInfo.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(4, true, false));
        Group grp = new Group(parent, 0);
        grp.setText("Properties");
        UIUtil.setStandardLayout((Composite)grp, 4);
        grp.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(4, true, false));
        new Label((Composite)grp, 0).setText(S.s(52) + ": ");
        this.widgetAddress = new Text((Composite)grp, 2052);
        this.widgetAddress.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.widgetAddress, 16));
        this.widgetAddress.setText(String.format("%Xh", this.address));
        this.widgetAddress.selectAll();
        this.widgetAddress.setFocus();
        new Label((Composite)grp, 0).setText("String type: ");
        this.widgetStringTypes = new Combo((Composite)grp, 12);
        GridData layoutData = UIUtil.createGridDataFillHorizontally();
        this.widgetStringTypes.setLayoutData((Object)layoutData);
        this.widgetStringTypes.add("(Automatic)");
        for (StringType st : StringType.values()) {
            this.widgetStringTypes.add(st.toString());
        }
        this.widgetStringTypes.select(0);
        new Label((Composite)grp, 0).setText("Min chars: ");
        this.widgetMinCount = new Text((Composite)grp, 2052);
        this.widgetMinCount.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.widgetAddress, 8));
        this.widgetMinCount.setText("");
        this.widgetMinCount.selectAll();
        new Label((Composite)grp, 0).setText("Max chars: ");
        this.widgetMaxCount = new Text((Composite)grp, 2052);
        this.widgetMaxCount.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.widgetAddress, 8));
        this.widgetMaxCount.setText(String.format("%X", this.address));
        this.widgetMaxCount.setText("");
        this.widgetMaxCount.selectAll();
        this.createOkayCancelButtons(parent);
        this.widgetOk = this.getButtonByStyle(32);
        this.widgetAddress.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DefineStringDialog.this.update();
            }
        });
        this.widgetAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefineStringDialog.this.update();
            }
        });
        this.update();
    }

    @Override
    protected void onConfirm() {
        this.info = new StringSetupInformation();
        this.info.address = this.getSelectedAddress();
        this.info.addressMax = -1L;
        this.info.minChars = Conversion.stringToInt(this.widgetMinCount.getText(), -1);
        this.info.maxChars = Conversion.stringToInt(this.widgetMaxCount.getText(), -1);
        this.info.stringType = this.getSelectedStringType();
        this.confirmed = true;
        super.onConfirm();
    }

    private void update() {
        INativeContinuousItem item;
        long a = this.getSelectedAddress();
        this.widgetOk.setEnabled(a >= 0L);
        String info = a < 0L ? "Invalid address" : (this.unit == null ? String.format("No native unit was provided, cannot retrieve information about location %Xh.", a) : ((item = this.unit.getNativeItemOver(a)) != null ? String.format("Beware, an item already occupies address %Xh.", a) : String.format("Will attempt to define string at address %Xh", a)));
        this.widgetInfo.setText(info);
    }

    private long getSelectedAddress() {
        return Conversion.stringToLong(this.widgetAddress.getText(), -1L);
    }

    private StringType getSelectedStringType() {
        int index = this.widgetStringTypes.getSelectionIndex();
        if (index <= 0 || index > StringType.values().length) {
            return null;
        }
        return StringType.values()[index - 1];
    }
}

