/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.IPropertyType;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.IPropertyTypePath;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeString;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.core.properties.impl.PropertyUtil;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertiesSetterDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(PropertiesSetterDialog.class);
    private IUnit unit;
    private IPropertyManager pm;
    private String description;
    private boolean showUnitType;
    private String regionName;
    private boolean includeSubRegions;
    private boolean sortOptionsAlphabetically;
    private boolean showInternalProperties;
    private boolean showDoNotShow;
    private boolean showApplyButton;
    private List<Control> controls = new ArrayList<Control>();
    private boolean retval;
    private Button btnDoNotShow;
    private boolean doNotShow;
    private static final String flagModified = "modified";

    public PropertiesSetterDialog(Shell parent, String caption) {
        super(parent, Strings.safe2(caption, "Properties"), true, true);
        this.scrolledContainer = true;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.retval;
    }

    public void setUnit(IUnit unit, boolean loadPM, boolean showUnitType) {
        this.unit = unit;
        if (loadPM) {
            this.pm = unit.getPropertyManager();
        }
        this.showUnitType = showUnitType;
    }

    public void setPropertyManager(IPropertyManager pm) {
        this.pm = pm;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRegionName(String regionName, boolean includeSubRegions) {
        this.regionName = regionName;
        this.includeSubRegions = includeSubRegions;
    }

    public void setShowInternalProperties(boolean showInternalProperties) {
        this.showInternalProperties = showInternalProperties;
    }

    public void setSortOptionsAlphabetically(boolean sortOptionsAlphabetically) {
        this.sortOptionsAlphabetically = sortOptionsAlphabetically;
    }

    public void setShowDoNotShowTickbox(boolean showDoNotShow) {
        this.showDoNotShow = showDoNotShow;
    }

    public void setShowApplyButton(boolean showApplyButton) {
        this.showApplyButton = showApplyButton;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        if (this.description != null) {
            Label desc = new Label(parent, 0);
            desc.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
            desc.setText(this.description);
        }
        if (this.unit != null && this.showUnitType) {
            new Label(parent, 0).setText(S.s(779) + ": ");
            Text widgetType = new Text(parent, 2060);
            widgetType.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            widgetType.setText(this.unit.getFormatType());
        }
        Group g = UIUtil.createGroupGrid(parent, S.s(666), 2, 2);
        ArrayList<IPropertyDefinitionManager> tbd = new ArrayList<IPropertyDefinitionManager>();
        IPropertyDefinitionManager pdm0 = this.pm.getPropertyDefinitionManager();
        if (this.regionName != null) {
            pdm0 = PropertyUtil.getNamespace(pdm0, this.regionName);
        }
        if (pdm0 == null) {
            logger.error("No property definition manager was found!", new Object[0]);
        } else {
            tbd.add(pdm0);
        }
        Group sub = g;
        while (!tbd.isEmpty()) {
            IPropertyDefinitionManager pdm = (IPropertyDefinitionManager)tbd.remove(0);
            ArrayList<IPropertyDefinition> defs = new ArrayList<IPropertyDefinition>(pdm.getDefinitions());
            if (this.sortOptionsAlphabetically) {
                Collections.sort(defs, new Comparator<IPropertyDefinition>(){

                    @Override
                    public int compare(IPropertyDefinition o1, IPropertyDefinition o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
            }
            for (IPropertyDefinition def : defs) {
                Text text;
                Object v;
                String name1;
                if ((def.getFlags() & 2) != 0 || def.isInternal() && !this.showInternalProperties) continue;
                String name = def.getName();
                try {
                    name1 = Strings.camelCaseToString(name, true, true);
                }
                catch (ParseException ex) {
                    name1 = name;
                }
                String propfqn = pdm.getNamespace() + "." + name;
                logger.i("- %s (%s)", propfqn, def);
                Label propname = new Label((Composite)sub, 0);
                propname.setText(name1 + ": ");
                Button ctl = null;
                IPropertyType t0 = def.getType();
                if (t0 instanceof IPropertyTypeBoolean) {
                    Button btn;
                    ctl = btn = new Button((Composite)sub, 32);
                    v = this.pm.getBooleanUnsafe(propfqn);
                    if (Booleans.isTrue((Boolean)v)) {
                        btn.setSelection(true);
                    }
                    btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PropertiesSetterDialog.this.setModifiedFlag((Control)btn, true);
                        }
                    });
                } else if (t0 instanceof IPropertyTypeInteger) {
                    text = UIUtil.createTextboxInGrid((Composite)sub, 2052, 10, 1, true, false);
                    ctl = text;
                    v = this.pm.getIntegerUnsafe(propfqn);
                    if (v != null) {
                        text.setText(((Integer)v).toString());
                    }
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            PropertiesSetterDialog.this.setModifiedFlag((Control)text, true);
                        }
                    });
                } else if (t0 instanceof IPropertyTypeString) {
                    text = UIUtil.createTextboxInGrid((Composite)sub, 2052, 40, 1, true, false);
                    ctl = text;
                    if (t0 instanceof IPropertyTypePath) {
                        text.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseUp(MouseEvent e) {
                                DirectoryDialog dlg = new DirectoryDialog(PropertiesSetterDialog.this.getShell(), 0);
                                dlg.setFilterPath(text.getText());
                                String path = dlg.open();
                                if (path != null) {
                                    text.setText(path);
                                }
                            }
                        });
                    }
                    if ((v = this.pm.getStringUnsafe(propfqn)) != null) {
                        text.setText((String)v);
                    }
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            PropertiesSetterDialog.this.setModifiedFlag((Control)text, true);
                        }
                    });
                } else {
                    new Label(parent, 0).setText("-");
                }
                String propdesc = def.getDescription();
                if (!Strings.isBlank(propdesc)) {
                    ctl.setToolTipText(propdesc);
                    propname.setToolTipText(String.format("Property: %s\nDescription: %s\nType: %s", propfqn, propdesc, def.getType()));
                }
                if (ctl == null) continue;
                if (ctl instanceof Text) {
                    ctl.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            ((Text)e.widget).selectAll();
                        }
                    });
                }
                ctl.setData("propertyType", (Object)t0);
                ctl.setData("propertyFQN", (Object)propfqn);
                this.controls.add((Control)ctl);
            }
            if (!this.includeSubRegions) continue;
            tbd.addAll(pdm.getChildren());
        }
        if (this.showDoNotShow) {
            this.btnDoNotShow = UIUtil.createCheckbox(parent, S.s(281), null);
            this.btnDoNotShow.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        }
        if (this.showApplyButton) {
            this.createButtons(parent, new int[]{32, 256, 0x20000000}, 32);
        } else {
            this.createOkayCancelButtons(parent);
        }
    }

    private void setModifiedFlag(Control ctl, boolean modified) {
        ctl.setData(flagModified, (Object)modified);
    }

    private boolean hasModifiedFlag(Control ctl) {
        return Boolean.TRUE.equals(ctl.getData(flagModified));
    }

    private void resetModifiedFlag() {
        for (Control ctl : this.controls) {
            ctl.setData(flagModified, (Object)false);
        }
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x20000000) {
            this.applyChanges();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    @Override
    protected void onConfirm() {
        this.applyChanges();
        this.doNotShow = this.btnDoNotShow != null && this.btnDoNotShow.getSelection();
        this.retval = true;
        super.onConfirm();
    }

    private void applyChanges() {
        PropertyChangeObject co = new PropertyChangeObject();
        for (Control ctl : this.controls) {
            if (!this.hasModifiedFlag(ctl)) continue;
            IPropertyType proptype = (IPropertyType)ctl.getData("propertyType");
            String propfqn = (String)ctl.getData("propertyFQN");
            boolean r = true;
            if (proptype instanceof IPropertyTypeBoolean) {
                boolean selected = ((Button)ctl).getSelection();
                r = this.pm.setBoolean(propfqn, selected, co);
            } else if (proptype instanceof IPropertyTypeInteger) {
                try {
                    int val = Integer.parseInt(((Text)ctl).getText());
                    r = this.pm.setInteger(propfqn, val, co);
                }
                catch (NumberFormatException e) {
                    logger.catching(e);
                }
            } else if (proptype instanceof IPropertyTypeString) {
                String text = ((Text)ctl).getText();
                r = this.pm.setString(propfqn, text, co);
            }
            if (r) continue;
            UI.warn("Illegal value for property: " + propfqn);
        }
        co.commit();
        this.resetModifiedFlag();
    }

    public Boolean getDoNotShow() {
        return this.doNotShow;
    }

    public int determineShownPropertyCount() {
        if (this.pm == null) {
            return 0;
        }
        IPropertyDefinitionManager pdm0 = this.pm.getPropertyDefinitionManager();
        if (this.regionName != null) {
            pdm0 = PropertyUtil.getNamespace(pdm0, this.regionName);
        }
        if (pdm0 == null) {
            return 0;
        }
        ArrayList<IPropertyDefinitionManager> tbd = new ArrayList<IPropertyDefinitionManager>();
        tbd.add(pdm0);
        int cnt = 0;
        while (!tbd.isEmpty()) {
            IPropertyDefinitionManager pdm = (IPropertyDefinitionManager)tbd.remove(0);
            ArrayList<IPropertyDefinition> defs = new ArrayList<IPropertyDefinition>(pdm.getDefinitions());
            for (IPropertyDefinition def : defs) {
                if ((def.getFlags() & 2) != 0 || def.isInternal() && !this.showInternalProperties) continue;
                ++cnt;
            }
            if (!this.includeSubRegions) continue;
            tbd.addAll(pdm.getChildren());
        }
        return cnt;
    }
}

