/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.Assets;
import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class UIAssetManager
extends SwtRegistry {
    private static final ILogger logger = GlobalLog.getLogger(UIAssetManager.class);
    private static UIAssetManager manager = null;
    private Map<String, Image> images = new HashMap<String, Image>();

    public static UIAssetManager getInstance() {
        if (manager == null) {
            manager = new UIAssetManager();
        }
        return manager;
    }

    private UIAssetManager() {
        super(Display.getCurrent());
    }

    public Image getImage(String filename) {
        Image asset = this.images.get(filename);
        if (asset == null) {
            try (InputStream in = Assets.getAsset(filename);){
                if (in == null) {
                    logger.warn("Image not found: %s", filename);
                } else {
                    asset = new Image((Device)this.display, in);
                }
                this.images.put(filename, asset);
            }
            catch (SWTException e) {
                logger.catching(e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return asset;
    }

    public Image getImage(String filename, AssetManagerOverlay overlay) {
        if (overlay == null) {
            return this.getImage(filename);
        }
        if (!overlay.hasLayer()) {
            return this.getImage(filename);
        }
        Image asset = this.images.get(filename + overlay.getId());
        if (asset == null) {
            asset = overlay.build(this.getImage(filename));
            this.images.put(filename + overlay.getId(), asset);
        }
        return asset;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Image image : this.images.values()) {
            image.dispose();
        }
    }
}

