/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.ErrorLogGenerator;
import com.pnfsoftware.jeb.client.JebNet;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.exceptions.UnitLockedException;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;

public class RcpErrorHandler {
    private static final ILogger logger = GlobalLog.getLogger(RcpErrorHandler.class);
    public static final long STD_FAILSAFE__SLIDING_WINDOW_DURATION_MS = 60000L;
    public static final int STD_FAILSAFE__MAX_REPORT_COUNT_PER_SLIDING_WINDOW = 5;
    private long failsafeSlidingWindowDurationMs = 60000L;
    private int failsafeMaxReportCountPerSlidingWindow = 5;
    private List<Long> errorTimestamps = new ArrayList<Long>();
    private RcpClientContext ctx;

    public RcpErrorHandler(RcpClientContext ctx) {
        this.ctx = ctx;
    }

    public void disableFailsafe() {
        this.failsafeSlidingWindowDurationMs = 0L;
        this.failsafeMaxReportCountPerSlidingWindow = 0;
    }

    public void enableFailsafe(long failsafeSlidingWindowDurationMs, int failsafeMaxReportCountPerSlidingWindow) {
        this.failsafeSlidingWindowDurationMs = failsafeSlidingWindowDurationMs;
        this.failsafeMaxReportCountPerSlidingWindow = failsafeMaxReportCountPerSlidingWindow;
    }

    public void handle(Throwable t) {
        logger.catching(t);
        try {
            this.processThrowableVerbose(t);
        }
        catch (Exception e) {
            logger.catchingSilent(e);
        }
    }

    private static void displayUnitLockedException(UnitLockedException e) {
        UI.error("Please wait, analysis is executing in the background...");
    }

    public void processThrowableVerbose(Throwable t) {
        this.processThrowable(t, true, false, false, null, null, null);
    }

    public void processThrowableSilent(Throwable t) {
        this.processThrowable(t, false, false, false, null, null, null);
    }

    public void processThrowable(Throwable t, boolean verbose, boolean forceUpload, boolean doNotUploadSample, String details, Map<String, Object> extramap, IUnit faultyUnit) {
        File prjFile;
        Object input;
        long ts;
        long delta;
        if (t instanceof UnitLockedException) {
            RcpErrorHandler.displayUnitLockedException((UnitLockedException)t);
            return;
        }
        long currentTs = System.currentTimeMillis();
        this.errorTimestamps.add(currentTs);
        if (this.failsafeMaxReportCountPerSlidingWindow > 0 && this.failsafeSlidingWindowDurationMs > 0L && this.errorTimestamps.size() > this.failsafeMaxReportCountPerSlidingWindow && (delta = currentTs - (ts = this.errorTimestamps.get(this.errorTimestamps.size() - this.failsafeMaxReportCountPerSlidingWindow - 1).longValue())) <= this.failsafeSlidingWindowDurationMs) {
            logger.debug("Error report not generated, too many exceptions are being reported", new Object[0]);
            return;
        }
        Throwable t0 = Throwables.getRootCause(t);
        boolean done = false;
        if (t0 instanceof ClassNotFoundException || t0 instanceof NoSuchFieldException || t0 instanceof NoSuchMethodException || t0 instanceof NoClassDefFoundError || t0 instanceof IncompatibleClassChangeError) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format("%s.\n%s.", S.s(310), S.s(193)));
            msg.append(String.format("\n\n%s: %s", S.s(304), t0));
            this.display(msg, verbose);
            logger.catching(t);
            done = true;
        } else if (t0 instanceof Error) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format("%s. %s.", S.s(795), S.s(323)));
            msg.append(String.format("\n\n%s: %s", S.s(304), t0));
            this.display(msg, verbose);
            logger.catching(t);
            done = true;
        } else if (t0 instanceof SWTException && Licensing.isReleaseBuild()) {
            verbose = false;
        }
        if (done) {
            return;
        }
        final ErrorLogGenerator gen = new ErrorLogGenerator(t);
        if (this.ctx.getEnginesContext() != null) {
            gen.recordEnginesInformation(this.ctx.getEnginesContext());
        }
        try {
            String supportPackageHash = Lists.getFirst(IO.readLines(new File(this.ctx.getProgramDirectory(), "INSTALLED_SP.TXT")));
            gen.addRecord("sp-hash", supportPackageHash);
        }
        catch (IOException supportPackageHash) {
            // empty catch block
        }
        String prjReloaded = "unknown";
        String prjSha256 = "";
        Long prjFilesize = -1L;
        ArrayList<String> artSha256List = new ArrayList<String>();
        ArrayList<Long> artFilesizeList = new ArrayList<Long>();
        ArrayList<String> artHeaderList = new ArrayList<String>();
        IRuntimeProject prj = this.ctx.getOpenedProject();
        if (prj != null) {
            prjReloaded = Boolean.toString(prj.isReloaded());
            for (ILiveArtifact a : prj.getLiveArtifacts()) {
                input = a.getArtifact().getInput();
                try {
                    InputStream in = input.getStream();
                    Throwable throwable = null;
                    try {
                        HashCalculator h = new HashCalculator(in, 16);
                        if (!h.compute()) continue;
                        artSha256List.add(Formatter.byteArrayToHexString(h.getSha256()));
                        artFilesizeList.add(input.getCurrentSize());
                        String hdrstr = "";
                        ByteBuffer hdr = input.getHeader();
                        if (hdr != null) {
                            int len = Math.min(16, hdr.remaining());
                            byte[] bytes = new byte[len];
                            hdr.get(bytes);
                            hdrstr = Formatter.byteArrayToHexString(bytes);
                        }
                        artHeaderList.add(hdrstr);
                    }
                    catch (Throwable h) {
                        throwable = h;
                        throw h;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable h) {
                                throwable.addSuppressed(h);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException in) {}
            }
        }
        if (this.ctx.getLastReloadedProjectPath() != null && (prjFile = new File(this.ctx.getLastReloadedProjectPath())).exists() && prjFile.canRead()) {
            prjFilesize = prjFile.length();
            try {
                FileInputStream in = new FileInputStream(prjFile);
                input = null;
                try {
                    HashCalculator h = new HashCalculator(in, 16);
                    if (h.compute()) {
                        prjSha256 = Formatter.byteArrayToHexString(h.getSha256());
                    }
                }
                catch (Throwable h) {
                    input = h;
                    throw h;
                }
                finally {
                    if (in != null) {
                        if (input != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable h) {
                                ((Throwable)input).addSuppressed(h);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
            }
            catch (IOException in) {
                // empty catch block
            }
        }
        gen.addRecord("project-reloaded", prjReloaded);
        gen.addRecord("project-sha256", prjSha256);
        gen.addRecord("project-filesize", prjFilesize);
        gen.addRecord("artifacts-sha256-list", Strings.join(",", artSha256List));
        gen.addRecord("artifacts-filesize-list", Strings.join(",", artFilesizeList));
        gen.addRecord("artifacts-header-list", Strings.join(",", artHeaderList));
        IPropertyManager pm = this.ctx.getPropertyManager();
        boolean cfgUploadErrorLogs = Booleans.toBoolean(pm.getBoolean(".UploadErrorLogs"));
        boolean cfgUploadErrorFiles = Booleans.toBoolean(pm.getBoolean(".UploadErrorFiles"));
        gen.addRecord("up-set", String.format("%b;%b", cfgUploadErrorLogs, cfgUploadErrorFiles));
        if (details != null) {
            gen.addRecord("details", details);
        }
        if (extramap != null) {
            for (String key : extramap.keySet()) {
                if (key == null) continue;
                Object value = extramap.get(key);
                gen.addRecord(key, value);
            }
        }
        if (faultyUnit != null) {
            try {
                gen.addRecord("unit_path", UnitUtil.buildFullyQualifiedUnitPath(faultyUnit, true, ">"));
                gen.addRecord("unit_type", faultyUnit.getFormatType());
            }
            catch (Exception e) {
                gen.addRecord("unit_info_Gen_error", "Cannot generate unit information");
            }
        }
        final boolean uploadErrorLogs = !Licensing.isDebugBuild() && (forceUpload || cfgUploadErrorLogs || Licensing.isDemoBuild());
        final boolean uploadErrorFiles = uploadErrorLogs && !doNotUploadSample && (forceUpload || cfgUploadErrorFiles || Licensing.isDemoBuild());
        final boolean verbose1 = verbose;
        ThreadUtil.start(Licensing.isDebugBuild() ? "UploadError" : null, new Runnable(){

            @Override
            public void run() {
                boolean devMode;
                boolean errorLogUploaded = false;
                if (uploadErrorLogs || uploadErrorFiles) {
                    Net net = new Net(RcpErrorHandler.this.ctx.getNetworkUtility());
                    if (uploadErrorLogs) {
                        String r = JebNet.post(net, "https://www.pnfsoftware.com/upload_errorlog", gen.getLog());
                        boolean bl = errorLogUploaded = r != null;
                    }
                    if (uploadErrorFiles) {
                        try {
                            File f = RcpErrorHandler.this.getPrimaryArtifact();
                            if (f == null) {
                                f = RcpErrorHandler.this.getReloadedProjectFile();
                            }
                            if (f != null) {
                                if (!f.isFile() || !f.canRead()) {
                                    throw new IOException("No file or cannot read artifact file: " + f);
                                }
                                if (f.length() <= 0x8000000L) {
                                    JebNet.uploadFile(net, f, true);
                                }
                            }
                        }
                        catch (Exception e) {
                            ErrorLogGenerator gen2 = new ErrorLogGenerator(e);
                            JebNet.post(net, "https://www.pnfsoftware.com/upload_errorlog", gen2.getLog());
                        }
                    }
                }
                boolean bl = devMode = RcpErrorHandler.this.ctx.isDevelopmentMode() || Licensing.isDebugBuild();
                if (!errorLogUploaded || devMode) {
                    File errorlogsFolder = new File(RcpErrorHandler.this.ctx.getBaseDirectory(), "errorlogs");
                    errorlogsFolder.mkdir();
                    String path = gen.dumpTo(errorlogsFolder.getAbsolutePath());
                    StringBuilder msg = new StringBuilder();
                    msg.append(String.format("%s.", S.s(305)));
                    msg.append(String.format("\n\n%s: %s.", S.s(307), path));
                    RcpErrorHandler.this.display(msg, verbose1);
                }
            }
        });
    }

    private void display(CharSequence msg, boolean verbose) {
        if (verbose) {
            UI.error(msg.toString());
        }
    }

    private File getPrimaryArtifact() throws IOException {
        IRuntimeProject prj = this.ctx.getOpenedProject();
        if (prj != null && !prj.getLiveArtifacts().isEmpty()) {
            IInput input = prj.getLiveArtifacts().get(0).getArtifact().getInput();
            if (input instanceof FileInput) {
                return ((FileInput)input).getFile();
            }
            try (InputStream in = input.getStream();){
                File f = IO.createTempFile();
                f.deleteOnExit();
                IO.writeFile(f, IO.readInputStream(in));
                File file = f;
                return file;
            }
        }
        return null;
    }

    private File getReloadedProjectFile() {
        File prjFile;
        if (this.ctx.getLastReloadedProjectPath() != null && (prjFile = new File(this.ctx.getLastReloadedProjectPath())).isFile() && prjFile.canRead()) {
            return prjFile;
        }
        return null;
    }
}

