/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.events.JC;
import com.pnfsoftware.jeb.client.events.JebClientEvent;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class FontManager
extends EventSource {
    private static final ILogger logger = GlobalLog.getLogger(FontManager.class);
    private Display display = Display.getCurrent();
    private IPropertyManager pm;
    private Font codeFont;

    public FontManager(IPropertyManager pm) {
        this.pm = pm;
        this.resetDefaults(false, false);
    }

    private FontManager() {
    }

    public FontManager clone() {
        FontManager dst = new FontManager();
        dst.display = this.display;
        dst.pm = this.pm;
        dst.codeFont = this.codeFont;
        return dst;
    }

    public void resetDefaults(boolean forceDefault, boolean notify) {
        this.codeFont = this.loadCodeFont(forceDefault);
        if (notify) {
            this.onFontChanged();
        }
    }

    public void restore(FontManager src, boolean notify) {
        this.pm = src.pm;
        this.display = src.display;
        this.codeFont = src.codeFont;
        if (notify) {
            this.onFontChanged();
        }
    }

    public Font getCodeFont() {
        return this.codeFont;
    }

    public void setCodeFont(Font codeFont) {
        this.saveCodeFont(codeFont);
        this.codeFont = codeFont;
        this.onFontChanged();
    }

    private void onFontChanged() {
        this.notifyListeners(new JebClientEvent(JC.CodeFontChanged, this.codeFont));
    }

    private void saveCodeFont(Font codeFontToSave) {
        if (this.pm != null) {
            String s = "";
            if (codeFontToSave != null) {
                FontData[] fdlist = codeFontToSave.getFontData();
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (FontData fd : fdlist) {
                    if (i >= 1) {
                        sb.append(",");
                    }
                    sb.append(fd.toString());
                    ++i;
                }
                s = sb.toString();
            }
            this.pm.setString(".ui.CodeFont", s);
        }
    }

    private Font loadCodeFont(boolean ignoreSettings) {
        FontData fd;
        Font newCodeFont = null;
        if (!ignoreSettings && this.pm != null) {
            try {
                String s = this.pm.getString(".ui.CodeFont");
                if (s != null && !s.isEmpty()) {
                    String[] elts = s.split(",");
                    FontData[] fdlist = new FontData[elts.length];
                    int i = 0;
                    for (String elt : elts) {
                        fdlist[i] = new FontData(elt);
                        ++i;
                    }
                    newCodeFont = UIAssetManager.getInstance().getFont(fdlist);
                }
            }
            catch (Exception e) {
                logger.catching(e);
            }
        }
        FontData[] fdlist = this.display.getFontList(null, true);
        HashMap<String, FontData> fontmap = new HashMap<String, FontData>();
        for (FontData fd2 : fdlist) {
            if (fd2.getStyle() != 0) continue;
            fontmap.put(fd2.getName(), fd2);
        }
        if (newCodeFont != null && !fontmap.containsKey((fd = newCodeFont.getFontData()[0]).getName())) {
            newCodeFont = null;
        }
        if (newCodeFont == null) {
            OSType ostype = OSType.determine();
            ArrayList<String> preferredNames = new ArrayList<String>();
            if (ostype.isWindows()) {
                preferredNames.add("Consolas");
            } else if (ostype.isMac()) {
                preferredNames.add("Menlo");
                preferredNames.add("Monaco");
            } else if (ostype.isLinux()) {
                preferredNames.add("DejaVu Sans Mono");
            }
            for (String preferredName : preferredNames) {
                if (!fontmap.containsKey(preferredName)) continue;
                FontData fd3 = (FontData)fontmap.get(preferredName);
                fd3.setHeight(8);
                newCodeFont = UIAssetManager.getInstance().getFont(fd3);
                break;
            }
            if (newCodeFont == null) {
                Font font = JFaceResources.getFont("org.eclipse.jface.textfont");
                fdlist = font.getFontData();
                FontDescriptor fd4 = FontDescriptor.createFrom(fdlist);
                fd4 = fd4.increaseHeight(-1);
                newCodeFont = UIAssetManager.getInstance().getFont(fd4);
            }
        }
        return newCodeFont;
    }

    public void registerWidget(final Control ctl) {
        ctl.setFont(this.getCodeFont());
        final IEventListener fontChangeListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                ctl.setFont((Font)e.getData());
            }
        };
        this.addListener(fontChangeListener);
        ctl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FontManager.this.removeListener(fontChangeListener);
            }
        });
    }
}

