/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.internal.databinding.swt.WidgetBooleanValueProperty;
import org.eclipse.jface.internal.databinding.swt.WidgetListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ControlFocusedProperty
extends WidgetBooleanValueProperty {
    @Override
    public boolean doGetBooleanValue(Object source) {
        return ((Control)source).isFocusControl();
    }

    @Override
    public void doSetBooleanValue(Object source, boolean value) {
        if (value) {
            ((Control)source).setFocus();
        }
    }

    @Override
    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        int[] events = new int[]{15, 16};
        return new ControlFocusListener(this, listener, events, null);
    }

    public String toString() {
        return "Control.focus <boolean>";
    }

    private static class ControlFocusListener
    extends WidgetListener {
        private ControlFocusListener(IProperty property, ISimplePropertyListener listener, int[] changeEvents, int[] staleEvents) {
            super(property, listener, changeEvents, staleEvents);
        }

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    this.fireChange(event.widget, Diffs.createValueDiff(Boolean.FALSE, Boolean.TRUE));
                    break;
                }
                case 16: {
                    this.fireChange(event.widget, Diffs.createValueDiff(Boolean.TRUE, Boolean.FALSE));
                }
            }
        }
    }
}

