/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.swt.widgets.Display;

public class DisplayRealm
extends Realm {
    private static List<DisplayRealm> realms = new ArrayList<DisplayRealm>();
    private Display display;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm getRealm(Display display) {
        List<DisplayRealm> list = realms;
        synchronized (list) {
            for (DisplayRealm element : realms) {
                if (element.display != display) continue;
                return element;
            }
            DisplayRealm result = new DisplayRealm(display);
            realms.add(result);
            return result;
        }
    }

    private DisplayRealm(Display display) {
        this.display = display;
    }

    @Override
    public boolean isCurrent() {
        return Display.getCurrent() == this.display;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        Runnable safeRunnable = () -> DisplayRealm.safeRun(runnable);
        if (!this.display.isDisposed()) {
            this.display.asyncExec(safeRunnable);
        }
    }

    @Override
    public void timerExec(int milliseconds, Runnable runnable) {
        if (!this.display.isDisposed()) {
            Runnable safeRunnable = () -> DisplayRealm.safeRun(runnable);
            this.display.timerExec(milliseconds, safeRunnable);
        }
    }

    public int hashCode() {
        return this.display == null ? 0 : this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisplayRealm other = (DisplayRealm)obj;
        return !(this.display == null ? other.display != null : !this.display.equals(other.display));
    }
}

