/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ValidatedObservableMap<K, V>
extends ObservableMap<K, V> {
    private IObservableMap<K, V> target;
    private IObservableValue<IStatus> validationStatus;
    private boolean stale;
    private boolean computeNextDiff = false;
    private boolean updatingTarget = false;
    private IMapChangeListener<K, V> targetChangeListener = event -> {
        if (this.updatingTarget) {
            return;
        }
        IStatus status = this.validationStatus.getValue();
        if (ValidatedObservableMap.isValid(status)) {
            if (this.stale) {
                this.stale = false;
                this.updateWrappedMap(new HashMap<K, V>(this.target));
            } else {
                MapDiff diff = event.diff;
                if (this.computeNextDiff) {
                    diff = Diffs.computeMapDiff(this.wrappedMap, this.target);
                    this.computeNextDiff = false;
                }
                this.applyDiff(diff, this.wrappedMap);
                this.fireMapChange(Diffs.unmodifiableDiff(diff));
            }
        } else {
            this.makeStale();
        }
    };
    private IStaleListener targetStaleListener = staleEvent -> this.fireStale();
    private IValueChangeListener<IStatus> validationStatusChangeListener = event -> {
        IStatus oldStatus = (IStatus)event.diff.getOldValue();
        IStatus newStatus = (IStatus)event.diff.getNewValue();
        if (this.stale && !ValidatedObservableMap.isValid(oldStatus) && ValidatedObservableMap.isValid(newStatus)) {
            this.stale = false;
            this.updateWrappedMap(new HashMap<K, V>(this.target));
            this.computeNextDiff = true;
        }
    };

    public ValidatedObservableMap(IObservableMap<K, V> target, IObservableValue<IStatus> validationStatus) {
        super(target.getRealm(), new HashMap<K, V>(target));
        Assert.isNotNull(validationStatus, "Validation status observable cannot be null");
        Assert.isTrue(target.getRealm().equals(validationStatus.getRealm()), "Target and validation status observables must be on the same realm");
        this.target = target;
        this.validationStatus = validationStatus;
        target.addMapChangeListener(this.targetChangeListener);
        target.addStaleListener(this.targetStaleListener);
        validationStatus.addValueChangeListener(this.validationStatusChangeListener);
    }

    private void updateWrappedMap(Map<K, V> newMap) {
        Map oldMap = this.wrappedMap;
        MapDiff<K, V> diff = Diffs.computeMapDiff(oldMap, newMap);
        this.wrappedMap = newMap;
        this.fireMapChange(diff);
    }

    private static boolean isValid(IStatus status) {
        return status.isOK() || status.matches(3);
    }

    private void applyDiff(MapDiff<? extends K, ? extends V> diff, Map<K, V> map) {
        Iterator<K> iterator = diff.getRemovedKeys().iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
        for (K key : diff.getChangedKeys()) {
            map.put(key, diff.getNewValue(key));
        }
        for (K key : diff.getAddedKeys()) {
            map.put(key, diff.getNewValue(key));
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    private void updateTargetMap(MapDiff<K, V> diff) {
        this.updatingTarget = true;
        try {
            if (this.stale) {
                this.stale = false;
                this.applyDiff(Diffs.computeMapDiff(this.target, this.wrappedMap), this.target);
            } else {
                this.applyDiff(diff, this.target);
            }
        }
        finally {
            this.updatingTarget = false;
        }
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.stale || this.target.isStale();
    }

    @Override
    public void clear() {
        this.checkRealm();
        if (this.isEmpty()) {
            return;
        }
        MapDiff diff = Diffs.computeMapDiff(this.wrappedMap, Collections.emptyMap());
        this.wrappedMap = new HashMap();
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
    }

    @Override
    public V put(K key, V value) {
        MapDiff<K, V> diff;
        V oldValue;
        this.checkRealm();
        if (this.wrappedMap.containsKey(key)) {
            oldValue = this.wrappedMap.put(key, value);
            diff = this.wrappedMap.containsKey(key) ? Diffs.createMapDiffSingleChange(key, oldValue, value) : Diffs.createMapDiffSingleRemove(key, oldValue);
        } else {
            oldValue = this.wrappedMap.put(key, value);
            diff = Diffs.createMapDiffSingleAdd(key, value);
        }
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkRealm();
        HashMap<? extends K, ? extends V> map = new HashMap<K, V>(this.wrappedMap);
        map.putAll(m);
        MapDiff diff = Diffs.computeMapDiff(this.wrappedMap, map);
        this.wrappedMap = map;
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
    }

    @Override
    public V remove(Object key) {
        this.checkRealm();
        if (!this.wrappedMap.containsKey(key)) {
            return null;
        }
        Object oldValue = this.wrappedMap.remove(key);
        MapDiff diff = Diffs.createMapDiffSingleRemove(key, oldValue);
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
        return oldValue;
    }

    @Override
    public Object getKeyType() {
        return this.target.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.target.getValueType();
    }

    @Override
    public synchronized void dispose() {
        this.target.removeMapChangeListener(this.targetChangeListener);
        this.target.removeStaleListener(this.targetStaleListener);
        this.validationStatus.removeValueChangeListener(this.validationStatusChangeListener);
        super.dispose();
    }
}

