/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.output;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.output.AbstractJDOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipOutput
extends AbstractJDOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipOutput.class);
    private final OutputStream os;
    private final File file;
    private final AtomicLong countClasses = new AtomicLong();
    private final AtomicLong countResources = new AtomicLong();
    private volatile ZipOutputStream zos;

    public ZipOutput(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("OutputStream can't be null.");
        }
        this.os = os;
        this.file = null;
    }

    public ZipOutput(File file) {
        if (file == null) {
            throw new NullPointerException("File can't be null.");
        }
        this.os = null;
        this.file = file;
    }

    @Override
    public void init(DecompilerOptions options, String basePath) {
        super.init(options, basePath);
        this.countClasses.set(0L);
        this.countResources.set(0L);
        this.zos = null;
        if (this.file == null) {
            LOGGER.info("ZIP output will be initialized for an OutputStream.");
            this.zos = new ZipOutputStream(this.os);
        } else {
            LOGGER.info("ZIP file output will be initialized - {}", (Object)this.file);
            try {
                File parentDir = this.file.getAbsoluteFile().getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (!parentDir.isDirectory()) {
                    LOGGER.error("Parent directory can't be created: {}", (Object)parentDir);
                    return;
                }
                this.zos = new ZipOutputStream(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                LOGGER.error("ZipOutput can't be initialized", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processClass(String className, String src) {
        if (className == null || src == null || this.zos == null) {
            return;
        }
        ZipOutputStream zipOutputStream = this.zos;
        synchronized (zipOutputStream) {
            try {
                this.zos.putNextEntry(new ZipEntry(className + ".java"));
                this.zos.write(src.getBytes(StandardCharsets.UTF_8));
                this.zos.closeEntry();
                this.countClasses.addAndGet(1L);
            }
            catch (IOException e) {
                LOGGER.error("Exception occured during writing decompiled class {} to a ZIP output.", (Object)className, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(String fileName, InputStream is) {
        if (this.options.isSkipResources() || fileName == null || is == null || this.zos == null) {
            return;
        }
        ZipOutputStream zipOutputStream = this.zos;
        synchronized (zipOutputStream) {
            try {
                this.zos.putNextEntry(new ZipEntry(fileName));
                IOUtils.copy(is, this.zos);
                this.zos.closeEntry();
                this.countResources.addAndGet(1L);
            }
            catch (IOException e) {
                LOGGER.error("Exception occured during writing resource {} to a ZIP output.", (Object)fileName, (Object)e);
            }
        }
    }

    @Override
    public void commit() {
        super.commit();
        if (this.zos != null) {
            try {
                if (this.file != null) {
                    this.zos.close();
                } else {
                    this.zos.finish();
                }
            }
            catch (IOException e) {
                LOGGER.error("Exception occured during finishing ZIP output.", e);
            }
        }
        LOGGER.info("Finished with {} class file(s) and {} resource file(s) written.", (Object)this.countClasses, (Object)this.countResources);
        this.zos = null;
    }
}

