/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;

public final class FileLoader
implements Loader {
    private final String basePath;

    public FileLoader() {
        this(null);
    }

    public FileLoader(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public byte[] load(String internalName) throws LoaderException {
        try {
            return Files.readAllBytes(this.fixPath(internalName));
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }

    @Override
    public boolean canLoad(String internalName) {
        Path fixedPath = this.fixPath(internalName);
        return fixedPath != null;
    }

    public Path fixPath(String internalName) {
        Path path = Paths.get(internalName, new String[0]);
        if (Files.isReadable(path)) {
            return path;
        }
        if (this.basePath != null && Files.isReadable(path = Paths.get(this.basePath, internalName))) {
            return path;
        }
        path = Paths.get(internalName + ".class", new String[0]);
        if (Files.isReadable(path)) {
            return path;
        }
        if (this.basePath != null && Files.isReadable(path = Paths.get(this.basePath, internalName + ".class"))) {
            return path;
        }
        return null;
    }
}

