/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.loader;

import com.github.kwart.jd.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;

public class CachedLoader
implements Loader {
    private final ConcurrentMap<String, byte[]> classCache = new ConcurrentHashMap<String, byte[]>();

    public void addClass(String name, byte[] bytecode) {
        if (name == null || bytecode == null) {
            return;
        }
        this.classCache.put(name.replace('\\', '/'), bytecode);
    }

    public void addClass(String name, InputStream is) throws LoaderException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            IOUtils.copy(is, baos);
            this.addClass(name, baos.toByteArray());
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }

    public Set<String> getClassNames() {
        return this.classCache.keySet();
    }

    @Override
    public byte[] load(String internalName) throws LoaderException {
        return this.findInCache(internalName);
    }

    @Override
    public boolean canLoad(String internalName) {
        return this.findInCache(internalName) != null;
    }

    private byte[] findInCache(String internalName) {
        if (internalName == null) {
            return null;
        }
        byte[] bytes = (byte[])this.classCache.get(internalName = internalName.replace('\\', '/'));
        return bytes != null ? bytes : (byte[])this.classCache.get(internalName + ".class");
    }
}

