/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.input;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.JavaDecompiler;
import com.github.kwart.jd.input.AbstractFileJDInput;
import com.github.kwart.jd.loader.FileLoader;
import com.github.kwart.jd.output.JDOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFileInput
extends AbstractFileJDInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileInput.class);

    public ClassFileInput(String path) {
        super(path);
    }

    public ClassFileInput(String filePath, String pattern) throws IllegalArgumentException {
        super(filePath, pattern);
    }

    @Override
    public void decompile(JavaDecompiler javaDecompiler, JDOutput jdOutput) {
        if (javaDecompiler == null || jdOutput == null) {
            LOGGER.warn("Decompiler or JDOutput are null");
            return;
        }
        String name = this.file.getName();
        if (this.skipThePath(name)) {
            return;
        }
        jdOutput.init(javaDecompiler.getOptions(), "");
        LOGGER.debug("Decompiling single class file {}", (Object)name);
        String nameWithoutClassSfx = IOUtils.isClassFile(name) ? IOUtils.cutClassSuffix(name) : name;
        jdOutput.processClass(nameWithoutClassSfx, javaDecompiler.decompileClass(new FileLoader(), this.file.getPath()));
        jdOutput.commit();
    }
}

