/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.input;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.JavaDecompiler;
import com.github.kwart.jd.input.AbstractFileJDInput;
import com.github.kwart.jd.loader.CachedLoader;
import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.output.JDOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDirInput
extends AbstractFileJDInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedDirInput.class);

    public CachedDirInput(String path, String pattern) throws IllegalArgumentException {
        super(path, pattern);
        if (!this.file.isDirectory()) {
            throw new IllegalArgumentException("Path doesn't denote a directory.");
        }
    }

    public CachedDirInput(String path) {
        this(path, null);
    }

    @Override
    public void decompile(JavaDecompiler javaDecompiler, JDOutput jdOutput) {
        if (javaDecompiler == null || jdOutput == null) {
            LOGGER.warn("Decompiler or JDOutput are null");
            return;
        }
        DecompilerOptions options = javaDecompiler.getOptions();
        CachedLoader cachedLoader = new CachedLoader();
        jdOutput.init(javaDecompiler.getOptions(), this.file.getPath());
        try {
            Path basePath = this.file.toPath();
            Files.walkFileTree(basePath, new CacheAndCopyFiles(cachedLoader, basePath, options.isSkipResources() ? null : jdOutput));
        }
        catch (IOException e) {
            LOGGER.error("Caching files failed", e);
        }
        Stream classNamesStream = options.isParallelProcessingAllowed() ? cachedLoader.getClassNames().parallelStream() : cachedLoader.getClassNames().stream();
        classNamesStream.filter(s -> !IOUtils.isInnerClass(s)).map(s -> IOUtils.cutClassSuffix(s)).forEach(name -> {
            try {
                jdOutput.processClass((String)name, javaDecompiler.decompileClass(cachedLoader, (String)name));
            }
            catch (Exception e) {
                LOGGER.error("Exception when decompiling class " + name, e);
            }
        });
        jdOutput.commit();
    }

    class CacheAndCopyFiles
    extends SimpleFileVisitor<Path> {
        private final CachedLoader cachedLoader;
        private final Path basePath;
        private final JDOutput jdOutput;

        CacheAndCopyFiles(CachedLoader cachedLoader, Path basePath, JDOutput jdOutput) {
            this.cachedLoader = cachedLoader;
            this.basePath = basePath;
            this.jdOutput = jdOutput;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            File relativizedFile = this.basePath.relativize(file).toFile();
            String filePath = relativizedFile.getPath();
            if (CachedDirInput.this.skipThePath(filePath)) {
                return FileVisitResult.CONTINUE;
            }
            if (IOUtils.isClassFile(filePath)) {
                LOGGER.debug("Caching {}", (Object)filePath);
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    this.cachedLoader.addClass(filePath, is);
                }
                catch (Exception e) {
                    LOGGER.error("Exception occured while caching class " + filePath, e);
                }
            } else if (this.jdOutput != null) {
                LOGGER.debug("Processing resource file {}", (Object)filePath);
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    this.jdOutput.processResource(filePath, is);
                }
                catch (IOException ioe) {
                    LOGGER.error("Resource processing failed for {}", (Object)filePath, (Object)ioe);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            LOGGER.debug("Visited directory: {}", (Object)dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOGGER.warn("Error while processing file " + file, exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

