/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.cli;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.JavaDecompiler;
import com.github.kwart.jd.JavaDecompilerConstants;
import com.github.kwart.jd.cli.CLIArguments;
import com.github.kwart.jd.cli.ExtCommander;
import com.github.kwart.jd.cli.InputOutputPair;
import com.github.kwart.jd.input.AbstractFileJDInput;
import com.github.kwart.jd.input.CachedDirInput;
import com.github.kwart.jd.input.ClassFileInput;
import com.github.kwart.jd.input.DirInput;
import com.github.kwart.jd.input.ZipFileInput;
import com.github.kwart.jd.output.AbstractJDOutput;
import com.github.kwart.jd.output.DirOutput;
import com.github.kwart.jd.output.JDOutput;
import com.github.kwart.jd.output.MultiOutput;
import com.github.kwart.jd.output.PrintStreamOutput;
import com.github.kwart.jd.output.StructuredDirOutput;
import com.github.kwart.jd.output.ZipOutput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    private Main() {
    }

    public static void main(String[] args) {
        CLIArguments cliArguments = new CLIArguments();
        ExtCommander jCmd = Main.initCommander(args, cliArguments);
        Main.setLoggingLevel(cliArguments.getLogLevel());
        if (jCmd.getUnknownOptions().contains("-")) {
            cliArguments.getFiles().add("-");
        }
        if (cliArguments.isHelp()) {
            jCmd.usage();
            System.exit(0);
        }
        if (cliArguments.isVersion()) {
            JCommander.getConsole().println(Main.getVersionLine());
            System.exit(0);
        }
        if (cliArguments.getFiles().isEmpty()) {
            jCmd.usage();
            System.exit(1);
        }
        JDOutput outputPlugin = Main.initOutput(cliArguments);
        JavaDecompiler javaDecompiler = new JavaDecompiler(cliArguments);
        boolean decompiled = false;
        for (String path : cliArguments.getFiles()) {
            File file;
            if ("-".equals(path)) {
                LOGGER.info("Decompiling from STD_IN");
                file = Main.readSystemIn();
            } else {
                LOGGER.info("Decompiling {}", (Object)path);
                file = new File(path);
            }
            if (file.exists()) {
                try {
                    InputOutputPair inOut = Main.getInOutPlugins(file, outputPlugin, cliArguments.getPattern(), cliArguments.isParallelProcessingAllowed());
                    inOut.getJdInput().decompile(javaDecompiler, inOut.getJdOutput());
                    decompiled = true;
                }
                catch (Exception e) {
                    LOGGER.warn("Problem occured during instantiating plugins", e);
                }
                continue;
            }
            LOGGER.warn("Input file {} doesn't exist", (Object)file);
        }
        if (!decompiled) {
            jCmd.usage();
            System.exit(2);
        }
    }

    private static ExtCommander initCommander(String[] args, CLIArguments cliArguments) {
        ExtCommander jCmd = new ExtCommander(cliArguments);
        jCmd.setAcceptUnknownOptions(true);
        jCmd.parse(args);
        jCmd.setProgramName("java -jar jd-cli.jar");
        jCmd.setUsageHead(Main.getVersionLine() + "\n\nThe jd-cli is a command line interface for the Java Decompiler (http://jd.benow.ca/). The application decompile classes, zip archives (.zip, .jar, .war, ...) and directories containing classes. Each supported input type has configured corresponding default output type (class->screen, zip->zip, directory->directory). Man can simply override the output type by specifying a command line parameter (-oc, -od, -oz). Multiple output type parameters can be used at once.");
        jCmd.setUsageTail("Examples:\n\n$ java -jar jd-cli.jar HelloWorld.class\n Shows decompiled class on a screen\n\n$ java -jar jd-cli.jar --skipResources -n -g ALL app.jar\n Decompiles app.jar to app.src.jar; It doesn't copy resources to the output jar, the decompiled classes contain line numbers as comments and the jd-cli prints the most verbose debug information about decompilation\n\n$ java -jar jd-cli.jar myapp.jar -od decompiled -oc\n Decompiles content of myapp.jar to directory named 'decompiled' and also on a screen\n\nThis program comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to redistribute it under GPLv3 conditions.");
        return jCmd;
    }

    private static JDOutput initOutput(CLIArguments cliArguments) {
        JDOutput outputPlugin = null;
        if (cliArguments.isOutputPluginSpecified()) {
            File dir;
            File zipFile;
            ArrayList<JDOutput> outPlugins = new ArrayList<JDOutput>();
            if (cliArguments.isConsoleOut()) {
                outPlugins.add(new PrintStreamOutput(System.out));
            }
            if ((zipFile = cliArguments.getZipOutFile()) != null) {
                try {
                    outPlugins.add(new ZipOutput(zipFile));
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to create the zip output", e);
                }
            }
            if ((dir = cliArguments.getDirOutFile()) != null) {
                try {
                    outPlugins.add(new DirOutput(dir));
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to create the directory output", e);
                }
            }
            if ((dir = cliArguments.getDirOutFileStructured()) != null) {
                try {
                    outPlugins.add(new StructuredDirOutput(dir));
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to create the structured directory output", e);
                }
            }
            if (outPlugins.size() == 1) {
                outputPlugin = (JDOutput)outPlugins.get(0);
            } else if (outPlugins.size() > 1) {
                outputPlugin = new MultiOutput(outPlugins);
            }
        }
        return outputPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutputPair getInOutPlugins(File inputFile, JDOutput outPlugin, String pattern, boolean useParallel) throws NullPointerException, IOException {
        AbstractFileJDInput jdIn = null;
        AbstractJDOutput jdOut = null;
        if (inputFile.isDirectory()) {
            jdIn = useParallel ? new CachedDirInput(inputFile.getPath(), pattern) : new DirInput(inputFile.getPath(), pattern);
            jdOut = new DirOutput(new File(inputFile.getName() + ".src"));
        } else {
            DataInputStream dis = new DataInputStream(new FileInputStream(inputFile));
            int magic = 0;
            try {
                magic = dis.readInt();
            }
            finally {
                IOUtils.closeQuietly(dis);
            }
            switch (magic) {
                case -889275714: {
                    jdIn = new ClassFileInput(inputFile.getPath(), pattern);
                    jdOut = new PrintStreamOutput(System.out);
                    break;
                }
                case 1347093252: {
                    jdIn = new ZipFileInput(inputFile.getPath(), pattern);
                    String decompiledZipName = inputFile.getName();
                    int suffixPos = decompiledZipName.lastIndexOf(".");
                    decompiledZipName = suffixPos >= 0 ? decompiledZipName.substring(0, suffixPos) + ".src" + decompiledZipName.substring(suffixPos) : decompiledZipName + ".src";
                    jdOut = new ZipOutput(new File(decompiledZipName));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("File type of the source was not recognized: " + inputFile);
                }
            }
        }
        return new InputOutputPair(jdIn, outPlugin, jdOut);
    }

    private static void setLoggingLevel(Level level) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT")).setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File readSystemIn() {
        File tempFile;
        block5: {
            FileOutputStream os = null;
            tempFile = null;
            InputStream fis = null;
            try {
                tempFile = File.createTempFile("jdTemp-", "-stdin");
                LOGGER.debug("Created a temporary file from the STD_IN: {}", (Object)tempFile.getAbsolutePath());
                os = new FileOutputStream(tempFile);
                IOUtils.copy(System.in, os);
                IOUtils.closeQuietly(fis);
            }
            catch (IOException e) {
                LOGGER.error("Copying STD_IN failed", e);
                break block5;
            }
            finally {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(os);
            }
            IOUtils.closeQuietly(os);
        }
        return tempFile;
    }

    private static String getVersionLine() {
        return "jd-cli version " + JavaDecompilerConstants.VERSION + " - Copyright (C) 2015-2021 Josef Cacek";
    }
}

