/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.cli;

import com.beust.jcommander.JCommander;
import java.util.ResourceBundle;

public class ExtCommander
extends JCommander {
    private String usageHead;
    private String usageTail;

    public ExtCommander() {
    }

    public ExtCommander(Object object, ResourceBundle bundle, String ... args) {
        super(object, bundle, args);
    }

    public ExtCommander(Object object, ResourceBundle bundle) {
        super(object, bundle);
    }

    public ExtCommander(Object object, String ... args) {
        super(object, args);
    }

    public ExtCommander(Object object) {
        super(object);
    }

    @Override
    public void usage(StringBuilder out, String indent) {
        int indentCount = indent.length();
        if (this.usageHead != null) {
            out.append(this.wrap(indentCount, this.usageHead)).append("\n");
        }
        super.usage(out, indent);
        if (this.usageTail != null) {
            out.append("\n").append(this.wrap(indentCount, this.usageTail));
        }
    }

    private String getIndent(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    protected String wrap(int indent, String text) {
        int max = this.getColumnSize();
        String[] lines = text.split("\n", -1);
        String indentStr = this.getIndent(indent);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            String[] words = line.split(" ", -1);
            StringBuilder lineSb = new StringBuilder();
            for (String word : words) {
                int lineLength = lineSb.length();
                if (lineLength > 0) {
                    if (indent + lineLength + word.length() > max) {
                        sb.append(indentStr).append((CharSequence)lineSb).append("\n");
                        lineSb.delete(0, lineSb.length());
                    } else {
                        lineSb.append(" ");
                    }
                }
                lineSb.append(word);
            }
            sb.append((CharSequence)lineSb);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getUsageHead() {
        return this.usageHead;
    }

    public void setUsageHead(String usageHead) {
        this.usageHead = usageHead;
    }

    public String getUsageTail() {
        return this.usageTail;
    }

    public void setUsageTail(String usageTail) {
        this.usageTail = usageTail;
    }
}

