/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.cli;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import com.github.kwart.jd.cli.LogLevelConverter;
import com.github.kwart.jd.options.DecompilerOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CLIArguments
implements DecompilerOptions {
    @Parameter(description="[Files to decompile]")
    private final List<String> files = new ArrayList<String>();
    @Parameter(names={"--help", "-h"}, description="shows this help", help=true)
    private boolean help;
    @Parameter(names={"--version", "-v"}, description="shows the version", help=true)
    private boolean version;
    @Parameter(names={"--outputZipFile", "-oz"}, description="takes a [zipFilePath] as a parameter and configures ZIP output for this path", converter=FileConverter.class)
    private File zipOutFile;
    @Parameter(names={"--outputDir", "-od"}, description="takes a [directoryPath] as a parameter and configures a flat DIR output for this path", converter=FileConverter.class)
    private File dirOutFile;
    @Parameter(names={"--outputDirStructured", "-ods"}, description="takes a [directoryPath] as a parameter and configures a structured DIR output for this path", converter=FileConverter.class)
    private File dirOutFileStructured;
    @Parameter(names={"--outputConsole", "-oc"}, description="enables output to system output stream")
    private boolean consoleOut;
    @Parameter(names={"--skipResources", "-sr"}, description="skips processing resources")
    private boolean skipResources;
    @Parameter(names={"--displayLineNumbers", "-n"}, description="displays line numbers in decompiled classes")
    private boolean displayLineNumbers;
    @Parameter(names={"--escapeUnicodeCharacters", "-eu"}, description="escape unicode characters in decompiled classes")
    private boolean escapeUnicodeCharacters;
    @Parameter(names={"--serialProcessing", "-sp"}, description="don't use parallel processing")
    private boolean serialProcessing;
    @Parameter(names={"--logLevel", "-g"}, description="takes [level] as parameter and sets it as the CLI log level. Possible values are: ALL, TRACE, DEBUG, INFO, WARN, ERROR, OFF", converter=LogLevelConverter.class)
    private final Level logLevel = Level.INFO;
    @Parameter(names={"--pattern", "-p"}, description="RegExp pattern which the to-be-decompiled file has to match. Not matching entries are skipped.")
    private final String pattern;

    public CLIArguments() {
        this.pattern = null;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public File getZipOutFile() {
        return this.zipOutFile;
    }

    public File getDirOutFile() {
        return this.dirOutFile;
    }

    public File getDirOutFileStructured() {
        return this.dirOutFileStructured;
    }

    public boolean isConsoleOut() {
        return this.consoleOut;
    }

    @Override
    public boolean isSkipResources() {
        return this.skipResources;
    }

    @Override
    public boolean isDisplayLineNumbers() {
        return this.displayLineNumbers;
    }

    @Override
    public boolean isEscapeUnicodeCharacters() {
        return this.escapeUnicodeCharacters;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isOutputPluginSpecified() {
        return this.consoleOut || this.zipOutFile != null || this.dirOutFile != null || this.dirOutFileStructured != null;
    }

    @Override
    public boolean isParallelProcessingAllowed() {
        return !this.serialProcessing;
    }
}

