/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd;

import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.printer.StringBuilderPrinter;
import org.jd.core.v1.ClassFileToJavaSourceDecompiler;
import org.jd.core.v1.api.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDecompiler {
    private static final ThreadLocal<ClassFileToJavaSourceDecompiler> DECOMPILER_TL = ThreadLocal.withInitial(() -> new ClassFileToJavaSourceDecompiler());
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaDecompiler.class);
    private final DecompilerOptions options;

    public JavaDecompiler(DecompilerOptions options) {
        this.options = options;
    }

    public String decompileClass(Loader loader, String internalName) {
        LOGGER.debug("Decompiling class {}", (Object)internalName);
        if (loader == null) {
            LOGGER.warn("Loader was null");
            return null;
        }
        StringBuilderPrinter sbp = new StringBuilderPrinter(this.options);
        try {
            DECOMPILER_TL.get().decompile(loader, sbp, internalName);
        }
        catch (Exception e) {
            LOGGER.error("Can't decompile " + internalName, e);
            return null;
        }
        return sbp.toString();
    }

    public DecompilerOptions getOptions() {
        return this.options;
    }
}

