/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd;

import com.github.kwart.jd.JavaDecompilerConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);
    private static final int BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        LOGGER.trace("Copying inputStream to outputStream");
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            os.write(buffer, 0, n);
            count += (long)n;
        }
        LOGGER.trace("{} bytes copied from IS to OS", (Object)count);
        return count;
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Closing InputStream failed.", ioe);
        }
    }

    public static void closeQuietly(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Closing OutputStream failed.", ioe);
        }
    }

    public static boolean isClassFile(String filePath) {
        return filePath.toLowerCase(Locale.ENGLISH).endsWith(".class");
    }

    public static boolean isInnerClass(String filePath) {
        return filePath.toLowerCase(Locale.ENGLISH).matches("^.+\\$.+\\.class$");
    }

    public static String cutClassSuffix(String classFilePath) {
        return classFilePath.substring(0, classFilePath.length() - JavaDecompilerConstants.CLASS_SUFFIX_LEN);
    }
}

