/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class Oracle10g
implements SpecialAlgorithm {
    private static final byte[] magicNumber = DatatypeConverter.parseHexBinary((String)"0123456789ABCDEF");
    private static final SecretKey keySpec = new SecretKeySpec(magicNumber, "DES");
    private static final IvParameterSpec iv = new IvParameterSpec(new byte[8]);
    private Cipher myCipher = null;

    public Oracle10g() {
        try {
            this.myCipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    private static final byte[] prepare(byte[] username, byte[] password) {
        byte[] nusername = ByteArray.toUpperCase(username);
        byte[] npassword = ByteArray.toUpperCase(password);
        int nplength = npassword.length;
        int nulength = nusername.length;
        byte[] result = new byte[(nulength + nplength) * 2];
        int auxIndex = 0;
        int i = 0;
        while (i < nulength) {
            result[auxIndex] = 0;
            result[++auxIndex] = nusername[i];
            ++auxIndex;
            ++i;
        }
        i = 0;
        while (i < nplength) {
            result[auxIndex] = 0;
            result[++auxIndex] = npassword[i];
            ++auxIndex;
            ++i;
        }
        byte[] paddedResult = result;
        int aux2Index = result.length;
        if (aux2Index % 8 != 0) {
            int cantPadding = 8 - aux2Index % 8;
            int newLength = aux2Index + cantPadding;
            paddedResult = new byte[newLength];
            int i2 = 0;
            while (i2 < aux2Index) {
                paddedResult[i2] = result[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < cantPadding) {
                paddedResult[aux2Index] = 0;
                ++aux2Index;
                ++i2;
            }
        }
        return paddedResult;
    }

    private static final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toHash(byte[] hash) {
        String returnValue = "";
        byte[] salt = this.getSaltFromHash(hash);
        returnValue = String.valueOf(returnValue) + Oracle10g.bytes2Utf8(salt).toUpperCase() + "/";
        byte[] aux = new byte[hash.length - salt.length - 1];
        int auxIndex = salt.length + 1;
        int i = 0;
        while (i < hash.length - salt.length - 1) {
            aux[i] = hash[auxIndex];
            ++auxIndex;
            ++i;
        }
        return String.valueOf(returnValue) + DatatypeConverter.printHexBinary((byte[])aux);
    }

    private static final byte[] getIn1(byte[] bprepared) {
        byte[] in2 = new byte[8];
        int auxIndex = 0;
        int myLength = bprepared.length;
        int i = myLength - 8;
        while (i < myLength) {
            in2[auxIndex] = bprepared[i];
            ++auxIndex;
            ++i;
        }
        return in2;
    }

    @Override
    public String crypt(String word, String salt) {
        return this.toHash(this.cryptPerf(word.getBytes(), salt.getBytes()));
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] returnValue = null;
        byte[] prepared = Oracle10g.prepare(salt, password);
        try {
            this.myCipher.init(1, (Key)keySpec, iv);
            returnValue = this.myCipher.doFinal(prepared);
            byte[] newKey = Oracle10g.getIn1(returnValue);
            SecretKeySpec keySpec2 = new SecretKeySpec(newKey, "DES");
            this.myCipher.init(1, (Key)keySpec2, iv);
            returnValue = this.myCipher.doFinal(prepared);
            returnValue = Oracle10g.getIn1(returnValue);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        returnValue = Oracle10g.insertPreSaltForCompatibilityWithJBrute(returnValue, salt);
        return returnValue;
    }

    private static final byte[] insertPreSaltForCompatibilityWithJBrute(byte[] b, byte[] username) {
        byte[] returnValue = new byte[b.length + 1 + username.length];
        int i = 0;
        while (i < username.length) {
            returnValue[i] = username[i];
            ++i;
        }
        returnValue[username.length] = 47;
        int auxIndex = username.length + 1;
        int i2 = 0;
        while (i2 < b.length) {
            returnValue[auxIndex] = b[i2];
            ++auxIndex;
            ++i2;
        }
        return returnValue;
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        int myIndex = 0;
        int i = 0;
        while (i < hash.length) {
            if ((char)hash[i] == '/') {
                myIndex = i;
                break;
            }
            ++i;
        }
        byte[] salt = new byte[myIndex];
        salt = new byte[myIndex];
        int i2 = 0;
        while (i2 < myIndex) {
            salt[i2] = hash[i2];
            ++i2;
        }
        return salt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        byte[] saltedWord = new byte[word.length + 1 + salt.length];
        int i = 0;
        while (i < salt.length) {
            saltedWord[i] = salt[i];
            ++i;
        }
        saltedWord[salt.length] = 47;
        int auxIndex = salt.length + 1;
        int i2 = 0;
        while (i2 < word.length) {
            saltedWord[auxIndex] = word[i2];
            ++auxIndex;
            ++i2;
        }
        return saltedWord;
    }

    @Override
    public byte[] toByteArray(String hash) {
        int separatorPos = hash.indexOf(47);
        String salt = hash.substring(0, separatorPos);
        String rest = hash.substring(separatorPos + 1, hash.length());
        byte[] bsalt = salt.getBytes();
        byte[] brest = DatatypeConverter.parseHexBinary((String)rest);
        byte[] bhash = new byte[bsalt.length + 1 + brest.length];
        int auxIndex = 0;
        int i = 0;
        while (i < bsalt.length) {
            bhash[i] = bsalt[i];
            ++i;
        }
        bhash[bsalt.length] = 47;
        auxIndex = bsalt.length + 1;
        i = 0;
        while (i < brest.length) {
            bhash[auxIndex] = brest[i];
            ++auxIndex;
            ++i;
        }
        return bhash;
    }
}

