/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class Informix1170
implements SpecialAlgorithm {
    private MessageDigest m = null;

    public Informix1170() {
        try {
            this.m = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        int myIndex = 0;
        int i = 0;
        while (i < hash.length) {
            if ((char)hash[i] == '/') {
                myIndex = i;
                break;
            }
            ++i;
        }
        byte[] salt = new byte[myIndex];
        int i2 = 0;
        while (i2 < myIndex) {
            salt[i2] = hash[i2];
            ++i2;
        }
        return salt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] hash) {
        byte[] salt = this.getSaltFromHash(hash);
        return ByteArray.concat(salt, word);
    }

    @Override
    public byte[] toByteArray(String hash) {
        int index = hash.indexOf(47);
        String salt = hash.substring(0, index);
        String pureHash = hash.substring(index + 1);
        pureHash = pureHash.replace('.', '+').replace('_', '/');
        byte[] aux = new BigInteger(salt).toByteArray();
        byte[] bsalt = new byte[]{47};
        bsalt = ByteArray.concat(aux, bsalt);
        byte[] bpureHash = DatatypeConverter.parseBase64Binary((String)pureHash);
        return ByteArray.concat(bsalt, bpureHash);
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        this.m.update(ByteArray.concat(salt, password));
        byte[] returnValue = this.m.digest();
        returnValue = Informix1170.insertPreSaltForCompatibilityWithJBrute(returnValue, salt);
        return returnValue;
    }

    @Override
    public String crypt(String word, String salt) {
        byte[] salt1 = null;
        if (salt == null) {
            salt1 = new byte[8];
            new Random().nextBytes(salt1);
        } else {
            salt1 = new BigInteger(salt).toByteArray();
        }
        return this.toHash(this.cryptPerf(word.getBytes(), salt1));
    }

    @Override
    public String toHash(byte[] hash) {
        String returnValue = "";
        byte[] salt = this.getSaltFromHash(hash);
        returnValue = String.valueOf(returnValue) + new BigInteger(salt).toString() + "/";
        byte[] aux = new byte[hash.length - salt.length - 1];
        int auxIndex = salt.length + 1;
        int i = 0;
        while (i < hash.length - salt.length - 1) {
            aux[i] = hash[auxIndex];
            ++auxIndex;
            ++i;
        }
        returnValue = String.valueOf(returnValue) + DatatypeConverter.printBase64Binary((byte[])aux).replace('/', '_').replace('+', '.');
        return returnValue;
    }

    private static byte[] insertPreSaltForCompatibilityWithJBrute(byte[] b, byte[] salt) {
        byte[] returnValue = new byte[b.length + 1 + salt.length];
        int i = 0;
        while (i < salt.length) {
            returnValue[i] = salt[i];
            ++i;
        }
        returnValue[salt.length] = 47;
        int auxIndex = salt.length + 1;
        int i2 = 0;
        while (i2 < b.length) {
            returnValue[auxIndex] = b[i2];
            ++auxIndex;
            ++i2;
        }
        return returnValue;
    }
}

