/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AvailableAlgorithms;
import entities.HashEntry;
import entities.IOProcessor;
import entities.JBruteThread;
import java.util.ArrayList;
import java.util.List;

public class ProcessResult {
    private boolean resolved = false;
    private List<HashEntry> encryptedHashes = new ArrayList<HashEntry>();
    private List<HashEntry> pendingEncryptedHashes = new ArrayList<HashEntry>();
    private List<String> decryptedHashes = new ArrayList<String>();
    private int testCount = 0;
    private int testTime = 5;
    private int hashesCount = 0;
    private String algorithmCodes = "0";
    private String chainedAlgorithmCase;
    private List<JBruteThread> threads = null;

    public List<HashEntry> getEncryptedHashes() {
        return this.encryptedHashes;
    }

    public List<HashEntry> getPendingEncryptedHashes() {
        return this.pendingEncryptedHashes;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public List<String> getDecryptedHashes() {
        return this.decryptedHashes;
    }

    public List<JBruteThread> getThreads() {
        return this.threads;
    }

    public void setThreads(List<JBruteThread> threads) {
        this.threads = threads;
    }

    private void removeFromPendingEncryptedHashes(String s) {
        int index = -1;
        for (HashEntry elem : this.pendingEncryptedHashes) {
            ++index;
            if (elem.getHash().equalsIgnoreCase(s)) break;
        }
        if (index >= 0) {
            this.pendingEncryptedHashes.remove(index);
        }
    }

    public void addEncryptedHash(HashEntry hash) {
        if (!this.hashIsAdded(hash)) {
            if (!IOProcessor.isHashInTheBox(hash)) {
                ++this.hashesCount;
                this.encryptedHashes.add(hash);
                this.pendingEncryptedHashes.add(hash);
            } else {
                System.out.println("Hash entry '" + hash.toString() + "' is in the box: " + IOProcessor.getWordFromHashEntry(hash));
            }
        } else {
            System.out.println("Duplicated hash entry '" + hash.toString() + "', ignoring it...");
        }
    }

    private boolean hashIsAdded(HashEntry newHash) {
        boolean isAdded = false;
        for (HashEntry addedHash : this.encryptedHashes) {
            if (!addedHash.toString().equals(newHash.toString())) continue;
            isAdded = true;
            break;
        }
        return isAdded;
    }

    public synchronized void addDecryption(String hash, String word) {
        this.decryptedHashes.add(String.valueOf(hash) + " --> " + word);
        HashEntry he = this.getHashEntryFromHash(hash);
        this.removeFromPendingEncryptedHashes(hash);
        if (this.pendingEncryptedHashes.size() == 0) {
            this.resolved = true;
        }
        for (JBruteThread myThread : this.threads) {
            myThread.setSomethingDifferent(true);
        }
        System.out.println("Founded: " + hash + ":" + word);
        IOProcessor.addHashEntryToTheBox(he, word);
    }

    private HashEntry getHashEntryFromHash(String hash) {
        HashEntry returnValue = null;
        for (HashEntry he : this.encryptedHashes) {
            if (!hash.equalsIgnoreCase(he.getHash())) continue;
            returnValue = new HashEntry();
            returnValue.setHash(he.getHash());
            returnValue.setSaltType(he.getSaltType());
            if (he.isPreSalt()) {
                returnValue.setPreSalt(he.getSalt());
                break;
            }
            returnValue.setPreSalt(he.getSalt());
            break;
        }
        if (returnValue == null) {
            System.err.println("[DEBUG] error! el hash no se encuentra en encryptedHashes!!!");
            returnValue = new HashEntry(hash);
        }
        return returnValue;
    }

    public int getTryesCount() {
        return this.testCount;
    }

    public void setTestCount(int countTryes) {
        this.testCount = countTryes;
    }

    public void incrementTestCount(int count) {
        this.testCount += count;
    }

    public String getAlgorithmCodes() {
        return this.algorithmCodes;
    }

    public void setAlgorithmCodes(String algorithmCodes) {
        this.algorithmCodes = algorithmCodes;
    }

    public String getChainedAlgorithmCase() {
        return this.chainedAlgorithmCase;
    }

    public void setChainedAlgorithmCase(String chainedAlgorithmCase) {
        StringBuilder aux = new StringBuilder(chainedAlgorithmCase.toUpperCase());
        this.chainedAlgorithmCase = aux.reverse().toString();
    }

    public boolean isChainedHash() {
        return this.algorithmCodes.length() > 1;
    }

    public void clearEncryptedHashes() {
        this.encryptedHashes.clear();
    }

    public void validateEncryptedHashes() {
        ArrayList<HashEntry> validatedHashes = new ArrayList<HashEntry>();
        char algChar = this.algorithmCodes.charAt(0);
        String lastCode = "" + algChar;
        int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(lastCode);
        String algorithmName = AvailableAlgorithms.getAlgorithmName(algorithmCode);
        for (HashEntry he : this.encryptedHashes) {
            if (AvailableAlgorithms.isValidHash(he.getHash(), algorithmCode)) {
                validatedHashes.add(he);
                continue;
            }
            System.out.println("Not a valid " + algorithmName + " hash: " + he.getHash() + " (i will ignore it).");
        }
        this.encryptedHashes = validatedHashes;
        this.pendingEncryptedHashes = validatedHashes;
    }

    public int getTestTime() {
        return this.testTime;
    }

    public void setTestTime(int testTime) {
        this.testTime = testTime;
    }

    public String getTestResult() {
        String output = new String(Integer.toString(this.testCount / this.testTime));
        if (output.length() >= 7) {
            output = String.valueOf(output.substring(0, output.length() - 3)) + "K";
        }
        return output;
    }
}

