/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.agent;

import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.manager.InstrumentationManager;
import com.aspect.snoop.ui.JavaSnoopView;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SnoopAgent {
    private static Instrumentation inst;
    private static InstrumentationManager manager;
    private static JavaSnoopView mainView;
    private static final int defaultGuiDelay = 5;

    public static JavaSnoopView getMainView() {
        return mainView;
    }

    public static void premain(String args, Instrumentation instrumentation) {
        SnoopAgent.install(args, instrumentation);
    }

    public static void agentmain(String args, Instrumentation instrumentation) {
        SnoopAgent.turnOffSecurity();
        SnoopAgent.install(args, instrumentation);
    }

    public static void install(String args, Instrumentation instrumentation) {
        inst = instrumentation;
        AgentLogger.debug("Loading manager...");
        manager = new InstrumentationManager(inst);
        AgentLogger.debug("Done with manager...");
        SnoopAgent.turnOffSecurity();
        AgentLogger.debug("Turned off security...");
        String[] arguments = args.split("\\|");
        String javaSnoopDir = arguments[0];
        int guiDelay = 5;
        try {
            guiDelay = Integer.parseInt(arguments[1]);
        }
        catch (Exception e) {
            AgentLogger.error("Gui delay wasn't supplied in agent arguments: defaulting to 5", e);
        }
        final int delay = guiDelay;
        final String lookAndFeelOverride = arguments.length == 3 ? arguments[2] : null;
        AgentLogger.debug("Adding runtime jars to system classloader...");
        String libDir = new File(javaSnoopDir).getAbsolutePath() + File.separator + "lib" + File.separator;
        try {
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "rsyntaxtextarea.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "aspect-swing-worker-1.1.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "aspect-appframework-1.0.3.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "bsh-2.0b4.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "jython.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "xom-1.1.jar"));
            inst.appendToSystemClassLoaderSearch(new JarFile(libDir + "xstream-1.3.1.jar"));
        }
        catch (IOException ex) {
            AgentLogger.fatal(ex);
        }
        AgentLogger.trace("Queueing GUI to run...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (delay != 0) {
                    AgentLogger.trace("Delaying " + delay + " seconds...");
                }
                try {
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (lookAndFeelOverride != null && !"".equals(lookAndFeelOverride)) {
                    try {
                        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                            if (!"Nimbus".equals(laf.getName())) continue;
                            UIManager.setLookAndFeel(laf.getClassName());
                            break;
                        }
                    }
                    catch (Exception ex) {
                        AgentLogger.error("Problem overriding LookAndFeel", ex);
                    }
                }
                AgentLogger.debug("Running GUI...");
                JavaSnoopView view = new JavaSnoopView(manager);
                mainView = view;
                AgentLogger.debug("GUI created. Running JavaSnoop!");
                view.setVisible(true);
            }
        });
    }

    private static void turnOffSecurity() {
        boolean restricted;
        boolean bl = restricted = System.getProperty("package.restrict.access.sun") != null;
        if (restricted) {
            Properties newProps = new Properties();
            Properties sysProps = System.getProperties();
            for (String prop : sysProps.stringPropertyNames()) {
                if (prop == null || prop.startsWith("package.restrict.")) continue;
                newProps.setProperty(prop, sysProps.getProperty(prop));
            }
            System.setProperties(newProps);
        }
        System.setSecurityManager(null);
    }

    public static Instrumentation getInstrumentation() {
        return inst;
    }

    public static InstrumentationManager getAgentManager() {
        return manager;
    }
}

