/*
 * Decompiled with CFR 0.152.
 */
package test;

import android.content.res.AXmlResourceParser;
import java.io.FileInputStream;

public class AXMLPrinter {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public static void main(String[] arguments2) {
        if (arguments2.length < 1) {
            AXMLPrinter.log("Usage: AXMLPrinter <binary xml file>", new Object[0]);
            return;
        }
        try {
            int type;
            AXmlResourceParser parser2 = new AXmlResourceParser();
            parser2.open(new FileInputStream(arguments2[0]));
            StringBuilder indent = new StringBuilder(10);
            String indentStep = "\t";
            while ((type = parser2.next()) != 1) {
                switch (type) {
                    case 0: {
                        AXMLPrinter.log("<?xml version=\"1.0\" encoding=\"utf-8\"?>", new Object[0]);
                        break;
                    }
                    case 2: {
                        AXMLPrinter.log("%s<%s%s", indent, AXMLPrinter.getNamespacePrefix(parser2.getPrefix()), parser2.getName());
                        indent.append("\t");
                        int namespaceCountBefore = parser2.getNamespaceCount(parser2.getDepth() - 1);
                        int namespaceCount = parser2.getNamespaceCount(parser2.getDepth());
                        int i = namespaceCountBefore;
                        while (i != namespaceCount) {
                            AXMLPrinter.log("%sxmlns:%s=\"%s\"", indent, parser2.getNamespacePrefix(i), parser2.getNamespaceUri(i));
                            ++i;
                        }
                        i = 0;
                        while (i != parser2.getAttributeCount()) {
                            AXMLPrinter.log("%s%s%s=\"%s\"", indent, AXMLPrinter.getNamespacePrefix(parser2.getAttributePrefix(i)), parser2.getAttributeName(i), AXMLPrinter.getAttributeValue(parser2, i));
                            ++i;
                        }
                        AXMLPrinter.log("%s>", indent);
                        break;
                    }
                    case 3: {
                        indent.setLength(indent.length() - "\t".length());
                        AXMLPrinter.log("%s</%s%s>", indent, AXMLPrinter.getNamespacePrefix(parser2.getPrefix()), parser2.getName());
                        break;
                    }
                    case 4: {
                        AXMLPrinter.log("%s%s", indent, parser2.getText());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return String.valueOf(prefix) + ":";
    }

    public static String getAttributeValue(AXmlResourceParser parser2, int index) {
        int type = parser2.getAttributeValueType(index);
        int data = parser2.getAttributeValueData(index);
        if (type == 3) {
            return parser2.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return String.valueOf(Float.toString(AXMLPrinter.complexToFloat(data))) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return String.valueOf(Float.toString(AXMLPrinter.complexToFloat(data))) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    public static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static void log(String format2, Object ... arguments2) {
        System.out.printf(format2, arguments2);
        System.out.println();
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

