/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.ValueBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum ValueBoxesValidator implements BodyValidator
{
    INSTANCE;


    public static ValueBoxesValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        Set set2 = Collections.newSetFromMap(new IdentityHashMap());
        for (ValueBox vb : body.getUseAndDefBoxes()) {
            if (set2.add(vb)) continue;
            exception.add(new ValidationException(vb, "Aliased value box : " + vb + " in " + body.getMethod()));
            for (Unit u : body.getUnits()) {
                System.err.println(u);
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

