/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public final class UsesValidator
extends Enum<UsesValidator>
implements BodyValidator {
    public static final /* enum */ UsesValidator INSTANCE = new UsesValidator();
    private static final /* synthetic */ UsesValidator[] $VALUES;

    public static UsesValidator[] values() {
        return (UsesValidator[])$VALUES.clone();
    }

    public static UsesValidator valueOf(String name) {
        return Enum.valueOf(UsesValidator.class, name);
    }

    public static UsesValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        PedanticThrowAnalysis throwAnalysis = PedanticThrowAnalysis.v();
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body, throwAnalysis, false);
        LocalDefs ld = LocalDefs.Factory.newLocalDefs(g, true);
        Chain<Local> locals = body.getLocals();
        for (Unit u : body.getUnits()) {
            for (ValueBox box : u.getUseBoxes()) {
                Value v = box.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                if (!locals.contains(l)) {
                    String msg = "Local " + v + " is referenced here but not in body's local-chain. (" + body.getMethod() + ")";
                    exception.add(new ValidationException(u, msg, msg));
                }
                if (!ld.getDefsOfAt(l, u).isEmpty()) continue;
                assert (this.graphEdgesAreValid(g, u)) : "broken graph found: " + u;
                exception.add(new ValidationException(u, "There is no path from a definition of " + v + " to this statement.", "(" + body.getMethod() + ") no defs for value: " + l + "!"));
            }
        }
    }

    private boolean graphEdgesAreValid(UnitGraph g, Unit u) {
        for (Unit p : g.getPredsOf(u)) {
            if (g.getSuccsOf(p).contains(u)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }

    static {
        $VALUES = new UsesValidator[]{INSTANCE};
    }
}

