/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.text.StringCharacterIterator;

public class StringTools {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getEscapedStringOf(String fromString) {
        char c;
        StringBuffer whole = new StringBuffer();
        StringBuffer mini = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        char cr = lineSeparator.charAt(0);
        int n = -1;
        if (lineSeparator.length() == 2) {
            c = lineSeparator.charAt(1);
        }
        for (char element2 : fromStringArray) {
            char ch = element2;
            if ((ch >= ' ' && ch <= '~' || ch == cr || ch == c) && ch != '\\') {
                whole.append(ch);
                continue;
            }
            mini.setLength(0);
            mini.append(Integer.toHexString(ch));
            while (mini.length() < 4) {
                mini.insert(0, "0");
            }
            mini.insert(0, "\\u");
            whole.append(mini.toString());
        }
        return whole.toString();
    }

    public static String getQuotedStringOf(String fromString) {
        StringBuffer toStringBuffer = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        toStringBuffer.append("\"");
        for (char ch : fromStringArray) {
            if (ch == '\\') {
                toStringBuffer.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                toStringBuffer.append("\\'");
                continue;
            }
            if (ch == '\"') {
                toStringBuffer.append("\\\"");
                continue;
            }
            if (ch == '\n') {
                toStringBuffer.append("\\n");
                continue;
            }
            if (ch == '\t') {
                toStringBuffer.append("\\t");
                continue;
            }
            if (ch == '\r') {
                toStringBuffer.append("\\r");
                continue;
            }
            if (ch == '\f') {
                toStringBuffer.append("\\f");
                continue;
            }
            if (ch >= ' ' && ch <= '~') {
                toStringBuffer.append(ch);
                continue;
            }
            toStringBuffer.append(StringTools.getUnicodeStringFromChar(ch));
        }
        toStringBuffer.append("\"");
        return toStringBuffer.toString();
    }

    public static String getUnicodeStringFromChar(char ch) {
        String s2 = Integer.toHexString(ch);
        String padding2 = null;
        switch (s2.length()) {
            case 1: {
                padding2 = "000";
                break;
            }
            case 2: {
                padding2 = "00";
                break;
            }
            case 3: {
                padding2 = "0";
                break;
            }
            case 4: {
                padding2 = "";
            }
        }
        return "\\u" + padding2 + s2;
    }

    public static String getUnEscapedStringOf(String str) {
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator iter2 = new StringCharacterIterator(str);
        char ch = iter2.first();
        while (ch != '\uffff') {
            if (ch != '\\') {
                buf.append(ch);
            } else {
                ch = iter2.next();
                if (ch == '\\') {
                    buf.append(ch);
                } else {
                    char format2 = StringTools.getCFormatChar(ch);
                    if (format2 != '\u0000') {
                        buf.append(format2);
                    } else if (ch == 'u') {
                        StringBuffer mini = new StringBuffer(4);
                        for (int i = 0; i < 4; ++i) {
                            mini.append(iter2.next());
                        }
                        ch = (char)Integer.parseInt(mini.toString(), 16);
                        buf.append(ch);
                    } else {
                        throw new RuntimeException("Unexpected char: " + ch);
                    }
                }
            }
            ch = iter2.next();
        }
        return buf.toString();
    }

    public static char getCFormatChar(char c) {
        char res;
        switch (c) {
            case 'n': {
                res = '\n';
                break;
            }
            case 't': {
                res = '\t';
                break;
            }
            case 'r': {
                res = '\r';
                break;
            }
            case 'b': {
                res = '\b';
                break;
            }
            case 'f': {
                res = '\f';
                break;
            }
            case '\"': {
                res = '\"';
                break;
            }
            case '\'': {
                res = '\'';
                break;
            }
            default: {
                res = '\u0000';
            }
        }
        return res;
    }
}

