/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import soot.util.ArrayNumberer;
import soot.util.Numberable;

public final class SmallNumberedMap<T> {
    private Numberable[] array = new Numberable[8];
    private Object[] values = new Object[8];
    private int size = 0;
    private ArrayNumberer universe;

    public SmallNumberedMap(ArrayNumberer universe) {
        this.universe = universe;
    }

    public boolean put(Numberable key2, T value2) {
        int pos = this.findPosition(key2);
        if (this.array[pos] == key2) {
            if (this.values[pos] == value2) {
                return false;
            }
            this.values[pos] = value2;
            return true;
        }
        ++this.size;
        if (this.size * 3 > this.array.length * 2) {
            this.doubleSize();
            pos = this.findPosition(key2);
        }
        this.array[pos] = key2;
        this.values[pos] = value2;
        return true;
    }

    public T get(Numberable key2) {
        return (T)this.values[this.findPosition(key2)];
    }

    public int nonNullSize() {
        int ret = 0;
        for (Object element2 : this.values) {
            if (element2 == null) continue;
            ++ret;
        }
        return ret;
    }

    public Iterator<Numberable> keyIterator() {
        return new KeyIterator(this);
    }

    public Iterator<T> iterator() {
        return new ValueIterator(this);
    }

    private final int findPosition(Numberable o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        while (this.array[number] != o) {
            if (this.array[number] == null) {
                return number;
            }
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private final void doubleSize() {
        int uniSize = this.universe.size();
        if (this.array.length * 128 > uniSize) {
            // empty if block
        }
        Numberable[] oldArray = this.array;
        Object[] oldValues = this.values;
        int newLength = this.array.length * 2;
        this.values = new Object[newLength];
        this.array = new Numberable[newLength];
        for (int i = 0; i < oldArray.length; ++i) {
            Numberable element2 = oldArray[i];
            if (element2 == null) continue;
            int pos = this.findPosition(element2);
            this.array[pos] = element2;
            this.values[pos] = oldValues[i];
        }
    }

    class ValueIterator
    extends SmallNumberedMapIterator<T> {
        ValueIterator(SmallNumberedMap map2) {
            super(map2);
        }

        @Override
        public final T next() {
            Object ret = SmallNumberedMap.this.values[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    class KeyIterator
    extends SmallNumberedMapIterator<Numberable> {
        KeyIterator(SmallNumberedMap map2) {
            super(map2);
        }

        @Override
        public final Numberable next() {
            Numberable ret = SmallNumberedMap.this.array[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    abstract class SmallNumberedMapIterator<C>
    implements Iterator<C> {
        SmallNumberedMap<C> map;
        int cur = 0;

        SmallNumberedMapIterator(SmallNumberedMap<C> map2) {
            this.map = map2;
            this.seekNext();
        }

        protected final void seekNext() {
            try {
                while (((SmallNumberedMap)this.map).values[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.cur != -1;
        }

        @Override
        public abstract C next();

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented.");
        }
    }
}

