/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.Set;
import soot.util.HashChain;

public class IterableSet<T>
extends HashChain<T>
implements Set<T> {
    public IterableSet(Collection<T> c) {
        this.addAll(c);
    }

    public IterableSet() {
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot add \"null\" to an IterableSet.");
        }
        if (this.contains(o)) {
            return false;
        }
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || !this.contains(o)) {
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterableSet)) {
            return false;
        }
        IterableSet other = (IterableSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (Object t : this) {
            if (other.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 23;
        for (Object t : this) {
            code += t.hashCode();
        }
        return code;
    }

    public Object clone() {
        IterableSet<T> s2 = new IterableSet<T>();
        s2.addAll(this);
        return s2;
    }

    public boolean isSubsetOf(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() > other.size()) {
            return false;
        }
        for (Object t : this) {
            if (other.contains(t)) continue;
            return false;
        }
        return true;
    }

    public boolean isSupersetOf(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() < other.size()) {
            return false;
        }
        for (Object t : other) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() >= other.size()) {
            return false;
        }
        return this.isSubsetOf(other);
    }

    public boolean isStrictSupersetOf(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() <= other.size()) {
            return false;
        }
        return this.isSupersetOf(other);
    }

    public boolean intersects(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set intersect an IterableSet with \"null\".");
        }
        if (other.size() < this.size()) {
            for (Object t : other) {
                if (!this.contains(t)) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!other.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public IterableSet<T> intersection(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set intersect an IterableSet with \"null\".");
        }
        IterableSet c = new IterableSet();
        if (other.size() < this.size()) {
            for (Object t : other) {
                if (!this.contains(t)) continue;
                c.add((T)t);
            }
        } else {
            for (Object t : this) {
                if (!other.contains(t)) continue;
                c.add((T)t);
            }
        }
        return c;
    }

    public IterableSet<T> union(IterableSet<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set union an IterableSet with \"null\".");
        }
        IterableSet<T> c = new IterableSet<T>();
        c.addAll(this);
        c.addAll(other);
        return c;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        for (Object t : this) {
            b.append(t.toString());
            b.append("\n");
        }
        return b.toString();
    }
}

