/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LocalDefs;

public class SimpleLocalDefs
implements LocalDefs {
    private LocalDefs def;

    public SimpleLocalDefs(UnitGraph graph) {
        this(graph, false);
    }

    public SimpleLocalDefs(UnitGraph graph, boolean omitSSA) {
        this((DirectedGraph<Unit>)graph, graph.getBody().getLocals(), omitSSA);
    }

    SimpleLocalDefs(DirectedGraph<Unit> graph, Collection<Local> locals, boolean omitSSA) {
        this(graph, locals.toArray(new Local[locals.size()]), omitSSA);
    }

    SimpleLocalDefs(DirectedGraph<Unit> graph, Local[] locals, boolean omitSSA) {
        int i;
        if (Options.v().time()) {
            Timers.v().defsTimer.start();
        }
        int N = locals.length;
        int[] oldNumbers = new int[N];
        for (i = 0; i < N; ++i) {
            oldNumbers[i] = locals[i].getNumber();
            locals[i].setNumber(i);
        }
        this.init(graph, locals, omitSSA);
        for (i = 0; i < N; ++i) {
            locals[i].setNumber(oldNumbers[i]);
        }
        if (Options.v().time()) {
            Timers.v().defsTimer.end();
        }
    }

    private void init(DirectedGraph<Unit> graph, Local[] locals, boolean omitSSA) {
        Object[] unitList = new List[locals.length];
        Arrays.fill(unitList, Collections.emptyList());
        boolean doFlowAnalsis = omitSSA;
        int units = 0;
        for (Unit unit : graph) {
            block5: for (ValueBox box : unit.getDefBoxes()) {
                Value v = box.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                int lno = l.getNumber();
                switch (unitList[lno].size()) {
                    case 0: {
                        unitList[lno] = Collections.singletonList(unit);
                        if (!omitSSA) continue block5;
                        ++units;
                        continue block5;
                    }
                    case 1: {
                        if (!omitSSA) {
                            ++units;
                        }
                        unitList[lno] = new ArrayList(unitList[lno]);
                        doFlowAnalsis = true;
                    }
                }
                unitList[lno].add(unit);
                ++units;
            }
        }
        this.def = doFlowAnalsis ? new FlowAssignment(graph, locals, (List<Unit>[])unitList, units, omitSSA) : new StaticSingleAssignment(locals, (List<Unit>[])unitList);
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s2) {
        return this.def.getDefsOfAt(l, s2);
    }

    private static class FlowAssignment
    extends ForwardFlowAnalysis<Unit, FlowBitSet>
    implements LocalDefs {
        final Map<Local, Integer> locals;
        final List<Unit>[] unitList;
        final int[] localRange;
        final Unit[] universe;
        private Map<Unit, Integer> indexOfUnit;

        FlowAssignment(DirectedGraph<Unit> graph, Local[] locals, List<Unit>[] unitList, int units, boolean omitSSA) {
            super(graph);
            int N = locals.length;
            this.locals = new HashMap<Local, Integer>(N * 3 / 2 + 7);
            this.unitList = unitList;
            this.universe = new Unit[units];
            this.indexOfUnit = new HashMap<Unit, Integer>(units);
            this.localRange = new int[N + 1];
            int j = 0;
            int i = 0;
            while (i < N) {
                if (!unitList[i].isEmpty()) {
                    this.locals.put(locals[i], i);
                    if (unitList[i].size() >= 2) {
                        for (Unit u : unitList[i]) {
                            this.indexOfUnit.put(u, j);
                            this.universe[j++] = u;
                        }
                    } else if (omitSSA) {
                        this.universe[j++] = unitList[i].get(0);
                    }
                }
                this.localRange[++i] = j;
            }
            assert (this.localRange[N] == units);
            this.doAnalysis();
            this.indexOfUnit.clear();
            this.indexOfUnit = null;
        }

        @Override
        public List<Unit> getDefsOfAt(Local l, Unit s2) {
            Integer lno = this.locals.get(l);
            if (lno == null) {
                return Collections.emptyList();
            }
            int from2 = this.localRange[lno];
            int to2 = this.localRange[lno + 1];
            assert (from2 <= to2);
            if (from2 == to2) {
                assert (this.unitList[lno].size() == 1);
                return this.unitList[lno];
            }
            return ((FlowBitSet)this.getFlowBefore(s2)).asList(from2, to2);
        }

        @Override
        protected boolean omissible(Unit u) {
            if (u.getDefBoxes().isEmpty()) {
                return true;
            }
            for (ValueBox vb : u.getDefBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                int lno = l.getNumber();
                return this.localRange[lno] == this.localRange[lno + 1];
            }
            return true;
        }

        @Override
        protected void flowThrough(FlowBitSet in, Unit unit, FlowBitSet out) {
            this.copy(in, out);
            for (ValueBox vb : unit.getDefBoxes()) {
                int to2;
                Local l;
                int lno;
                int from2;
                Value v = vb.getValue();
                if (!(v instanceof Local) || (from2 = this.localRange[lno = (l = (Local)v).getNumber()]) == (to2 = this.localRange[1 + lno])) continue;
                assert (from2 <= to2);
                if (to2 - from2 == 1) {
                    out.set(from2);
                    continue;
                }
                out.clear(from2, to2);
                out.set(this.indexOfUnit.get(unit));
            }
        }

        @Override
        protected void copy(FlowBitSet source, FlowBitSet dest) {
            if (dest == source) {
                return;
            }
            dest.clear();
            dest.or(source);
        }

        @Override
        protected FlowBitSet newInitialFlow() {
            return new FlowBitSet();
        }

        @Override
        protected void mergeInto(Unit succNode, FlowBitSet inout, FlowBitSet in) {
            inout.or(in);
        }

        @Override
        protected void merge(FlowBitSet in1, FlowBitSet in2, FlowBitSet out) {
            throw new UnsupportedOperationException("should never be called");
        }

        class FlowBitSet
        extends BitSet {
            private static final long serialVersionUID = -8348696077189400377L;

            FlowBitSet() {
                super(FlowAssignment.this.universe.length);
            }

            List<Unit> asList(int fromIndex, int toIndex) {
                FlowBitSet bits2 = this;
                if (FlowAssignment.this.universe.length < toIndex || toIndex < fromIndex || fromIndex < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (fromIndex == toIndex) {
                    return Collections.emptyList();
                }
                if (fromIndex == toIndex - 1) {
                    if (bits2.get(fromIndex)) {
                        return Collections.singletonList(FlowAssignment.this.universe[fromIndex]);
                    }
                    return Collections.emptyList();
                }
                int i = bits2.nextSetBit(fromIndex);
                if (i < 0 || i >= toIndex) {
                    return Collections.emptyList();
                }
                if (i == toIndex - 1) {
                    return Collections.singletonList(FlowAssignment.this.universe[i]);
                }
                ArrayList<Unit> elements = new ArrayList<Unit>(toIndex - i);
                do {
                    int endOfRun = Math.min(toIndex, bits2.nextClearBit(i + 1));
                    do {
                        elements.add(FlowAssignment.this.universe[i++]);
                    } while (i < endOfRun);
                } while (i < toIndex && (i = bits2.nextSetBit(i + 1)) >= 0 && i < toIndex);
                return elements;
            }
        }
    }

    private static class StaticSingleAssignment
    implements LocalDefs {
        final Map<Local, List<Unit>> result;

        StaticSingleAssignment(Local[] locals, List<Unit>[] unitList) {
            assert (locals.length == unitList.length);
            int N = locals.length;
            this.result = new HashMap<Local, List<Unit>>(N * 3 / 2 + 7);
            for (int i = 0; i < N; ++i) {
                if (unitList[i].isEmpty()) continue;
                assert (unitList[i].size() == 1);
                this.result.put(locals[i], unitList[i]);
            }
        }

        @Override
        public List<Unit> getDefsOfAt(Local l, Unit s2) {
            List<Unit> lst = this.result.get(l);
            if (lst == null) {
                return Collections.emptyList();
            }
            return lst;
        }
    }
}

