/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.AbstractFlowAnalysis;
import soot.util.Numberable;
import soot.util.PriorityQueue;

public abstract class FlowAnalysis<N, A>
extends AbstractFlowAnalysis<N, A> {
    protected Map<N, A> unitToAfterFlow;
    protected Map<N, A> filterUnitToAfterFlow = Collections.emptyMap();

    public FlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
        this.unitToAfterFlow = new IdentityHashMap<N, A>(graph.size() * 2 + 1);
    }

    protected abstract void flowThrough(A var1, N var2, A var3);

    public A getFlowAfter(N s2) {
        A a2 = this.unitToAfterFlow.get(s2);
        return a2 == null ? this.newInitialFlow() : a2;
    }

    @Override
    public A getFlowBefore(N s2) {
        Object a2 = this.unitToBeforeFlow.get(s2);
        return (A)(a2 == null ? this.newInitialFlow() : a2);
    }

    private void initFlow(Iterable<Entry<N, A>> universe, Map<N, A> in, Map<N, A> out) {
        assert (universe != null);
        assert (in != null);
        assert (out != null);
        for (Entry<N, A> n : universe) {
            boolean omit = true;
            if (n.in.length > 1) {
                n.inFlow = this.newInitialFlow();
                omit = !n.isRealStronglyConnected;
            } else {
                assert (n.in.length == 1) : "missing superhead";
                n.inFlow = n.in[0].outFlow;
                assert (n.inFlow != null) : "topological order is broken";
            }
            n.outFlow = omit && this.omissible(n.data) ? n.inFlow : this.newInitialFlow();
            in.put(n.data, n.inFlow);
            out.put(n.data, n.outFlow);
        }
    }

    protected boolean omissible(N n) {
        return false;
    }

    final int doAnalysis(GraphView gv, InteractionFlowHandler ifh, Map<N, A> inFlow, Map<N, A> outFlow) {
        assert (gv != null);
        assert (ifh != null);
        ifh = Options.v().interactive_mode() ? ifh : InteractionFlowHandler.NONE;
        List<Entry<N, A>> universe = Orderer.INSTANCE.newUniverse(this.graph, gv, this.entryInitialFlow());
        this.initFlow(universe, inFlow, outFlow);
        PriorityQueue<Entry<N, A>> q = PriorityQueue.of(universe, true);
        int numComputations = 0;
        Entry e;
        while ((e = (Entry)q.poll()) != null) {
            Entry<D, F>[] in = e.in;
            if (in.length > 1) {
                this.copy(in[0].outFlow, e.inFlow);
                for (int i = 1; i < in.length; ++i) {
                    this.mergeInto(e.data, e.inFlow, in[i].outFlow);
                }
            }
            ifh.handleFlowIn(this, e.data);
            boolean hasChanged = this.flowThrough(e);
            ifh.handleFlowOut(this, e.data);
            if (hasChanged) {
                q.addAll(Arrays.asList(e.out));
            }
            ++numComputations;
        }
        return numComputations;
    }

    private boolean flowThrough(Entry<N, A> d) {
        if (d.inFlow == d.outFlow) {
            assert (!d.isRealStronglyConnected || d.in.length == 1);
            return true;
        }
        if (d.isRealStronglyConnected) {
            Object out = this.newInitialFlow();
            this.flowThrough(d.inFlow, d.data, out);
            if (out.equals(d.outFlow)) {
                return false;
            }
            this.copy(out, d.outFlow);
            return true;
        }
        this.flowThrough(d.inFlow, d.data, d.outFlow);
        return true;
    }

    static enum GraphView {
        BACKWARD{

            @Override
            <N> List<N> getEntries(DirectedGraph<N> g) {
                return g.getTails();
            }

            @Override
            <N> List<N> getOut(DirectedGraph<N> g, N s2) {
                return g.getPredsOf(s2);
            }
        }
        ,
        FORWARD{

            @Override
            <N> List<N> getEntries(DirectedGraph<N> g) {
                return g.getHeads();
            }

            @Override
            <N> List<N> getOut(DirectedGraph<N> g, N s2) {
                return g.getSuccsOf(s2);
            }
        };


        abstract <N> List<N> getEntries(DirectedGraph<N> var1);

        abstract <N> List<N> getOut(DirectedGraph<N> var1, N var2);
    }

    static enum InteractionFlowHandler {
        NONE,
        FORWARD{

            @Override
            public <A, N> void handleFlowIn(FlowAnalysis<N, A> a2, N s2) {
                this.beforeEvent(this.stop(s2), a2, s2);
            }

            @Override
            public <A, N> void handleFlowOut(FlowAnalysis<N, A> a2, N s2) {
                this.afterEvent(InteractionHandler.v(), a2, s2);
            }
        }
        ,
        BACKWARD{

            @Override
            public <A, N> void handleFlowIn(FlowAnalysis<N, A> a2, N s2) {
                this.afterEvent(this.stop(s2), a2, s2);
            }

            @Override
            public <A, N> void handleFlowOut(FlowAnalysis<N, A> a2, N s2) {
                this.beforeEvent(InteractionHandler.v(), a2, s2);
            }
        };


        <A, N> void beforeEvent(InteractionHandler i, FlowAnalysis<N, A> a2, N s2) {
            Object savedFlow = a2.filterUnitToBeforeFlow.get(s2);
            if (savedFlow == null) {
                savedFlow = a2.newInitialFlow();
            }
            a2.copy(a2.unitToBeforeFlow.get(s2), savedFlow);
            i.handleBeforeAnalysisEvent(new FlowInfo(savedFlow, s2, true));
        }

        <A, N> void afterEvent(InteractionHandler i, FlowAnalysis<N, A> a2, N s2) {
            Object savedFlow = a2.filterUnitToAfterFlow.get(s2);
            if (savedFlow == null) {
                savedFlow = a2.newInitialFlow();
            }
            a2.copy(a2.unitToAfterFlow.get(s2), savedFlow);
            i.handleAfterAnalysisEvent(new FlowInfo(savedFlow, s2, false));
        }

        InteractionHandler stop(Object s2) {
            InteractionHandler h = InteractionHandler.v();
            ArrayList<Object> stopList = h.getStopUnitList();
            if (stopList != null && stopList.contains(s2)) {
                h.handleStopAtNodeEvent(s2);
            }
            return h;
        }

        public <A, N> void handleFlowIn(FlowAnalysis<N, A> a2, N s2) {
        }

        public <A, N> void handleFlowOut(FlowAnalysis<N, A> a2, N s2) {
        }
    }

    static final class Orderer
    extends Enum<Orderer> {
        public static final /* enum */ Orderer INSTANCE = new Orderer();
        private static final /* synthetic */ Orderer[] $VALUES;

        public static Orderer[] values() {
            return (Orderer[])$VALUES.clone();
        }

        public static Orderer valueOf(String name) {
            return Enum.valueOf(Orderer.class, name);
        }

        <D, F> List<Entry<D, F>> newUniverse(DirectedGraph<D> g, GraphView gv, F entryFlow) {
            int n = g.size();
            ArrayDeque<Entry<D, F>> s2 = new ArrayDeque<Entry<D, F>>(n);
            ArrayList<Entry<D, F>> universe = new ArrayList<Entry<D, F>>(n);
            HashMap visited = new HashMap((n + 1) * 4 / 3);
            Entry superEntry = new Entry(null, null);
            this.visitEntry(visited, superEntry, gv.getEntries(g));
            superEntry.outFlow = entryFlow;
            Entry[] sv = new Entry[g.size()];
            int[] si = new int[g.size()];
            int index = 0;
            int i = 0;
            Entry v = superEntry;
            while (true) {
                if (i < v.out.length) {
                    Entry w = v.out[i++];
                    if (w.number != Integer.MIN_VALUE) continue;
                    w.number = s2.size();
                    s2.add(w);
                    this.visitEntry(visited, w, gv.getOut(g, w.data));
                    si[index] = i;
                    sv[index] = v;
                    ++index;
                    i = 0;
                    v = w;
                    continue;
                }
                if (index == 0) {
                    assert (universe.size() <= g.size());
                    Collections.reverse(universe);
                    return universe;
                }
                universe.add(v);
                this.sccPop(s2, v);
                v = sv[--index];
                i = si[index];
            }
        }

        private <D, F> Entry<D, F>[] visitEntry(Map<D, Entry<D, F>> visited, Entry<D, F> v, List<D> out) {
            int n = out.size();
            Entry[] a2 = new Entry[n];
            assert (out instanceof RandomAccess);
            for (int i = 0; i < n; ++i) {
                a2[i] = this.getEntryOf(visited, out.get(i), v);
            }
            v.out = a2;
            return a2;
        }

        private <D, F> Entry<D, F> getEntryOf(Map<D, Entry<D, F>> visited, D d, Entry<D, F> v) {
            Entry<D, F> newEntry = new Entry<D, F>(d, v);
            Entry<D, F> oldEntry = visited.put(d, newEntry);
            if (oldEntry == null) {
                return newEntry;
            }
            visited.put(d, oldEntry);
            if (oldEntry == v) {
                oldEntry.isRealStronglyConnected = true;
            }
            int l = oldEntry.in.length;
            oldEntry.in = Arrays.copyOf(oldEntry.in, l + 1);
            oldEntry.in[l] = v;
            return oldEntry;
        }

        private <D, F> void sccPop(Deque<Entry<D, F>> s2, Entry<D, F> v) {
            int min2 = v.number;
            for (Entry e : v.out) {
                assert (e.number > Integer.MIN_VALUE);
                min2 = Math.min(min2, e.number);
            }
            if (min2 != v.number) {
                v.number = min2;
                return;
            }
            Entry<D, F> w = s2.removeLast();
            w.number = Integer.MAX_VALUE;
            if (w == v) {
                return;
            }
            w.isRealStronglyConnected = true;
            do {
                w = s2.removeLast();
                assert (w.number >= v.number);
                w.isRealStronglyConnected = true;
                w.number = Integer.MAX_VALUE;
            } while (w != v);
            assert (w.in.length >= 2);
        }

        static {
            $VALUES = new Orderer[]{INSTANCE};
        }
    }

    static class Entry<D, F>
    implements Numberable {
        final D data;
        int number;
        boolean isRealStronglyConnected;
        Entry<D, F>[] in;
        Entry<D, F>[] out;
        F inFlow;
        F outFlow;

        Entry(D u, Entry<D, F> pred) {
            this.in = new Entry[]{pred};
            this.data = u;
            this.number = Integer.MIN_VALUE;
            this.isRealStronglyConnected = false;
        }

        public String toString() {
            return this.data.toString();
        }

        @Override
        public void setNumber(int n) {
            this.number = n;
        }

        @Override
        public int getNumber() {
            return this.number;
        }
    }
}

